<?xml version="1.0" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="yes" />

<xsl:template match="/">
   <html>
     <head>
      <link rel="stylesheet" type="text/css" href="styledata.css" />
       <title> Some Interesting information about <xsl:value-of select="count(/data/item)" /> famous physicists </title>
     </head>
    <body>
   <table border="1"> 
  <tr><th> Name </th> <th> Birthday </th> <th> Birthplace </th> 
  <th>Rowcount </th>
  </tr>
 
  <xsl:for-each select="/data/item[substring(normalize-space(birthday),string-length(normalize-space(birthday))-3,4) &gt;= 1900]" >
    <xsl:sort select="normalize-space(name)" />
    <xsl:apply-templates select="." >
      <xsl:with-param name="rowCount" select="position()" />
    </xsl:apply-templates>
  </xsl:for-each>

   </table> 
    </body>
  </html>
</xsl:template>


<xsl:template match="/data/item" > 
   <xsl:param name="rowCount" />
   <xsl:variable name="rowBgColor" >
       <xsl:choose>
       <xsl:when test="$rowCount mod 2 = 0">
           <xsl:text>white</xsl:text>
       </xsl:when>
       <xsl:when test="$rowCount mod 2 = 1" >
          <xsl:text>orange</xsl:text>
       </xsl:when>
       <xsl:otherwise> <xsl:text></xsl:text></xsl:otherwise>
    </xsl:choose>  
  </xsl:variable>
    <tr bgcolor="{$rowBgColor}" >
      <td> <xsl:value-of select="name" /> </td>
      <td> <xsl:value-of select="birthday" /> </td>
      <td> <xsl:value-of select="birthPlace" /> </td>
      <td> <xsl:value-of select="$rowCount" /> </td>
   </tr> </xsl:template>
</xsl:stylesheet>
