<?xml version="1.0" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="yes" />

<xsl:template match="/">
   <html>
     <head>
      <link rel="stylesheet" type="text/css" href="styledata.css" />
       <title> Some Interesting information about <xsl:value-of select="count(/data/item)" /> famous physicists </title>
     </head>
    <body>
    <xsl:call-template name="generateToC" />
    <hr size="1" noshade="noshade" width="80%" />
    <xsl:call-template name="generateContent" />
    </body>
    </html>
</xsl:template>

<xsl:template name="generateToC" >
  <h3>Physicists: Alphabetical </h3>
  <ul>
   <xsl:for-each select="/data/item">
     <xsl:sort select="name" />
     <li> <a href="#{@ref}"><xsl:value-of select="name" /></a></li>
   </xsl:for-each>
  </ul>
</xsl:template>

<xsl:template name="generateContent" >
   <h3> Physicists: Chronologically by birthdate </h3>
   <table cellpadding="1" cellspacing="0"  border="1">
     <tr class="head2"> <td bgcolor="white"> </td>
       <td>Name </td> <td> Birth Date </td> <td>Birthplace</td></tr>
   <xsl:for-each select="/data/item">
    <xsl:sort data-type="number" 
      select="substring(normalize-space(birthday),string-length(normalize-space(birthday))-3,4)" />
    <xsl:apply-templates select="." mode="generateTableContent" >
      <xsl:with-param name="rowCount" select="position()" />
    </xsl:apply-templates>
  </xsl:for-each>
  </table>
</xsl:template>
 
<xsl:template match="/data/item"  mode="generateTableContent"> 
   <xsl:param name="rowCount" />
   <xsl:variable name="rowBgColor" >
       <xsl:choose>
       <xsl:when test="$rowCount mod 2 = 0">
           <xsl:text>#cccccc</xsl:text>
       </xsl:when>
       <xsl:when test="$rowCount mod 2 = 1" >
          <xsl:text>orange</xsl:text>
       </xsl:when>
       <xsl:otherwise> <xsl:text></xsl:text></xsl:otherwise>
    </xsl:choose>  
  </xsl:variable>
    <tr class="head" bgcolor="white" >
      <td align="center" bgcolor="{$rowBgColor}" width="1%" >
           <a id="{@ref}"><xsl:value-of select="$rowCount" /> </a>
      </td>
      <td style="white-space: pre" > <xsl:value-of select="name" /> </td>
      <td style="white-space: pre" width="10%" > <xsl:value-of select="birthday" /> </td>
      <td style="white-space: pre" width="10%"> <xsl:value-of select="birthPlace" /> </td>
   </tr> 
   <tr>
     <td> </td>
     <td colspan="3">
       <xsl:copy-of select="desc/node()" />
     </td>
   </tr>  
   </xsl:template>

</xsl:stylesheet>
