// toolbar.js - written by Stefan Koch, Netscape Communications Corp.

var ref= window;
var platform= (navigator.appVersion.indexOf("Mac")==-1);


// bring up security window at the beginning
netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserWrite");
netscape.security.PrivilegeManager.disablePrivilege("UniversalBrowserWrite");


// Toolbar constructor

function Toolbar(id, tb, posX, posY, width, height) {
	// properties
	this.id= id;
	this.tb= tb;
	this.posX= posX;
	this.posY= posY;
	this.width= width;
	this.height= height;
	this.first= true;
	
	this.outsidePosX= 100;
	this.outsidePosY= 100;
	this.eventCount= 0;
	this.toleranceX= 70;
	this.toleranceY= 50;
	this.dispWin= null;
	this.barsize= null;

	// methods
	this.show= toolbar_show;
	this.hide= toolbar_hide;
	this.showDropzone= toolbar_showDropzone;
	this.hideDropzone= toolbar_hideDropzone;
	this.moveTo= toolbar_moveTo;
	this.moveIn= toolbar_moveIn;
	this.moveOut= toolbar_moveOut;
	this.changeState= toolbar_changeState;
	this.isInside= toolbar_isInside;
	this.startDrag= toolbar_startDrag;
	this.drag= toolbar_drag;
	this.endDrag= toolbar_endDrag;
	
	this.content= this.tb.document.content;
	this.tb.left= this.posX;
	this.tb.top= this.posY;
	
	if (this.width==null) {
		this.tb.clip.width+= 8;
		this.content.clip.width+= 8;
		this.width= this.content.clip.width;
	}
	
	if (this.height==null) {
		this.height= this.content.clip.height;
	}
	
	this.tb.clip.width= this.width;
	this.content.clip.width= this.width;
	this.tb.clip.height= this.height;
	this.content.clip.height= this.height;
	
	this.inside= true;
	
	this.content.document.captureEvents(Event.MOUSEDOWN | Event.MOUSEUP);
	this.content.document.onmousedown= new Function("e", "return " + this.id + ".startDrag(e)");
	this.content.document.onmouseup= new Function("e", "return " + this.id + ".endDrag(e)");
}


// show toolbar either inside (state==true) or outside (state==false) the window

function toolbar_show(state) {
	var inside;
	if (state!=null) inside= state
	else inside= this.inside;
	
	if (inside) {
		this.tb.visibility= "show";
		this.content.visibility= "show";
		if (this.dispWin!=null) {
			this.dispWin.close();
			this.dispWin= null;
		}
	} else {
		if (this.dispWin!=null) {
			this.dispWin.close();
			this.dispWin= null;
		}
		
		this.tb.visibility= "hide";
		this.content.visibility= "hide";
		if (!platform) this.showDropzone();
		
		// create borderless window
		netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserWrite");
		this.dispWin= open(this.content.src, "toolbarWindow", "titlebar=no,alwaysRaised=yes,dependent=yes,screenX=" 
						+ this.outsidePosX + ",screenY=" + this.outsidePosY + ",outerWidth=" 
						+ this.width + ",outerHeight=" + this.height);
		netscape.security.PrivilegeManager.disablePrivilege("UniversalBrowserWrite");
		this.dispWin.ref= window;
					
		// capture events inside new window
		this.dispWin.document.captureEvents(Event.MOUSEDOWN, Event.MOUSEUP);
		this.dispWin.document.onmousedown= new Function("e", "return " + this.id + ".startDrag(e)");
		this.dispWin.document.onmouseup= new Function("e", "return " + this.id + ".endDrag(e)");
	}
}


// hide toolbar inside the window

function toolbar_hide(state) {
	var inside;
	if (state!=null) inside= state
	else inside= this.inside;
	
	if (inside) {
		this.tb.visibility= "hide";
		this.content.visibility= "hide";
	}
}


// show dropzone inside window

function toolbar_showDropzone() {
	this.content.visibility= "hide";
	this.tb.visibility= "show";
}


// hide dropzone

function toolbar_hideDropzone() {
	if (platform) {
		this.tb.visibility= "hide";
		this.content.visibility= "hide";
	}
}


// move toolbar to certain position - either inside or outside the window

function toolbar_moveTo(x, y, state) {
	var inside;
	if (state!=null) inside= state
	else inside= this.inside;
	
	if (inside) {
		this.posX= x;
		this.posY= y;
		this.tb.left= this.posX;
		this.tb.top= this.posY;
	} else {
		this.outsidePosX= x;
		this.outsidePosY= y;
		if (this.dispWin!=null) this.dispWin.moveTo(x,y);
	}
}


// move toolbar outside of window 

function toolbar_moveOut() {
	if (this.inside) {
		this.hide();
		this.inside= false;
		this.show();
	}
}


// move toolbar inside of window 

function toolbar_moveIn() {
	if (!this.inside) {
		this.hide();
		this.inside= true;
		this.show();
	}
}


// move toobar inside or outside of window depending on the actual state

function toolbar_changeState() {
	if (this.inside) this.moveOut();
	else this.moveIn();
}


// check if toolbar is inside of window

function toolbar_isInside() {
	return this.inside;
}


// event handler for mousedown event

function toolbar_startDrag(e) {
	this.startX= e.layerX;
	this.startY= e.layerY;
	if (this.inside) {
		if (this.barsize==null) this.barsize= e.screenY-window.screenY-e.pageY;
		this.content.document.captureEvents(Event.MOUSEMOVE);
		this.content.document.onmousemove= new Function("e", "return " + this.id + ".drag(e)");
		this.moveTo(e.screenX-this.startX, e.screenY-this.startY, false)
		if (!this.first) this.show(false);
	} else {
		if (this.dispWin!=null) {
			this.dispWin.document.captureEvents(Event.MOUSEMOVE);
			this.dispWin.document.onmousemove= new Function("e", "return " + this.id + ".drag(e)");
		}
	}
	return false;
}


// event handler for 'drag' event

function toolbar_drag(e) {
	if (this.first) return false;
	this.eventCount++;
	if (this.eventCount>5) this.eventCount= 0;
	if (this.eventCount==0) {
		if ((this.inside) || (platform))
			this.dispWin.moveTo(e.screenX-this.startX, e.screenY-this.startY);
		var scrX= window.screenX+this.content.pageX;
		var scrY= window.screenY+this.content.pageY;
		if (this.barsize!=null) scrY+= this.barsize;
			else scrY+= 100;
		if ((e.screenX>scrX-this.toleranceX) && (e.screenX<scrX+this.width+this.toleranceX) &&
			(e.screenY>scrY-this.toleranceY) && (e.screenY<scrY+this.height+this.toleranceY)) {
			this.showDropzone();
		} else this.hideDropzone();
	}
	return false;
}


// event handler for mouseup event

function toolbar_endDrag(e) {
	if (this.inside) {
		this.content.document.releaseEvents(Event.MOUSEMOVE);
		this.content.document.onmousemove= null;
		this.moveTo(e.screenX-this.startX, e.screenY-this.startY, false);
		
		var scrX= window.screenX+this.content.pageX;
		var scrY= window.screenY+this.content.pageY;
		if (this.barsize!=null) scrY+= this.barsize;
			else scrY+= 100;
		if ((e.screenX>scrX-this.toleranceX) && (e.screenX<scrX+this.width+this.toleranceX) &&
			(e.screenY>scrY-this.toleranceY) && (e.screenY<scrY+this.height+this.toleranceY)) {
			this.show();
		} else {
			this.first= false;
			this.moveOut();
		}
	} else {
		this.dispWin.document.releaseEvents(Event.MOUSEMOVE);
		this.dispWin.document.onmousemove= null;
		
		var scrX= window.screenX+this.content.pageX;
		var scrY= window.screenY+this.content.pageY;
		if (this.barsize!=null) scrY+= this.barsize;
			else scrY+= 100;
		if ((e.screenX>scrX-this.toleranceX) && (e.screenX<scrX+this.width+this.toleranceX) &&
			(e.screenY>scrY-this.toleranceY) && (e.screenY<scrY+this.height+this.toleranceY)) {
			this.moveIn();
		} else {
			if (!platform) this.moveTo(e.screenX-this.startX, e.screenY-this.startY);
		}
	}
	return false;
}
