/*
 * newsbox.js, by angus@netscape.com
 * No formal support offered. 
 */

function swapBox(ref) {
/*
 This function is called to swap the "clone" tape with the "real" tape.
 It is called whenever the active tape is about to run out.
 See docs for more info on this concept.
*/

 if (ref.activeBox == ref.boxLayer) {
  ref.activeBox = ref.boxLayerSub;
  ref.nonActiveBox = ref.boxLayer;
  return true;
 }
 ref.activeBox=ref.boxLayer;
 ref.nonActiveBox=ref.boxLayerSub;
 return true;
}

function slideBox(ref,inc) {
/*
 This function is called using setInterval. It slides the ticker ever so
 slightly in each iteration. It performs checks to see if it should be 
 swapping the tape, and it also performs checks to make sure that it has
 the "backup" tape on the correct side of the "active" tape, in case the
 user switches gears by sliding the tape in the opposite direction.
*/
 ref.boxLayer.moveBy(0,inc);
 ref.boxLayerSub.moveBy(0,inc);

 if ((ref.activeBox.top < (ref.activeBox.clip.height*-1)) && (ref.velocity<0)) {
  ref.activeBox.moveBy(0,ref.activeBox.clip.height*2);
  swapBox(ref);
 }
 if ((ref.activeBox.top > ref.activeBox.clip.height) && (ref.velocity>0)) {
  ref.activeBox.moveBy(0,ref.realWidth*-2);
  swapBox(ref);
 }
 if ((ref.velocity>0)&&(ref.activeBox.top>0) && 
	(ref.nonActiveBox.top > (ref.activeBox.top-ref.activeBox.clip.height))) {
 		ref.nonActiveBox.moveTo(0,ref.activeBox.top-ref.activeBox.clip.height);
	}
if ((ref.velocity<0)&&(ref.activeBox.top<(0-ref.activeBox.clip.height+ref.height)) && 
	(ref.nonActiveBox.top < (ref.activeBox.top+ref.activeBox.clip.height))) {
 		ref.nonActiveBox.moveTo(0,ref.activeBox.top+ref.activeBox.clip.height);
	}
}

function startBox() {
/*
 this is the Ticker.start() method. It checks to make sure the user hasn't placed
 the ticker into stop mode before starting (because this is called from mouseover
 events also). It then optimizes the interval time difference and the movement per
 iteration to work out so that slideTicker is called every 15 or more seconds (this
 is to avoid really short timeout periods). It then fires off an interval to start
 the motion.
*/

 ref = this;
 if (!ref.velocity) ref=this.parent;
 if (ref.active) ref.stop();
 if (ref.stopped == true) return(false);
 var increment = 1000/Math.abs(ref.velocity);
 var amount = ref.velocity/Math.abs(ref.velocity);
 while (increment < 25) {
  amount *=2;
  increment *=2;
 }
 ref.active = setInterval(slideBox,increment,ref,amount);
 return(true);
}

function stopBox() {
clearInterval(this.active);
}

function boxSlowVelocity(e) {
/*
 Called whenever the mouse goes over the ticker tape. Stops the ticker,
 reduces velocity to 50%, and restarts the ticker. Only does this if the
 ticker motion is currently active. (Ticker.active is the interval ID)
 Routes off the event if its happening over an anchor.
*/

 if (e.target.constructor == window.Url) return routeEvent(e);
 if (this.parent.active) {
 this.parent.stop();
 this.parent.velocity *= .5;
 this.parent.start();
 return true;
}
}

function boxSpeedVelocity(e) {
/*
 Called whenever the mouse goes out of the ticker tape. Stops the ticker,
 increases velocity back up to 100%, and restarts the ticker. Only does this if the
 ticker motion is currently active. (Ticker.active is the interval ID)
 Routes off the event if its happening over an anchor.
*/


 if (e.target.constructor == window.Url) return routeEvent(e);
 if (this.parent.active) {
 this.parent.stop();
 this.parent.velocity *= 2;
 this.parent.start();
 return true;
}
}

function makeSubBox() {
/*
 Called in the Ticker constructor phase, this creates the initial "clone"
 tape by instantiating a new layer.
*/

 ref = this.parent;
 ref.boxLayerSub = new Layer(ref.width,ref.container);
 if (ref.velocity < 0) ref.boxLayerSub.top=ref.height;
 if (ref.velocity > 0) ref.boxLayerSub.top=ref.height*-1;
 ref.boxLayerSub.top=0;
 ref.boxLayerSub.clip.width = ref.width;
 ref.boxLayerSub.visibility="inherit";
 ref.boxLayerSub.src=ref.src;
 ref.boxLayerSub.onMouseOver = boxSlowVelocity;
 ref.boxLayerSub.onMouseOut = boxSpeedVelocity;
 ref.boxLayerSub.parent = ref;
 ref.nonActiveBox = ref.boxLayerSub;
 ref.boxLayerSub.onLoad=ref.start;
}

function makeBox(ref) {
/*
 Called in the Ticker constructor phase, this creates the initial "active"
 tape by instantiating a new layer.
*/

 ref.boxLayer = new Layer(ref.width,ref.container);
 ref.boxLayer.left=0;
 ref.boxLayer.top=0;
 ref.boxLayer.clip.width = ref.width;
 ref.boxLayer.visibility="inherit";
 ref.boxLayer.src=ref.src;
 ref.activeBox = ref.boxLayer;
 ref.boxLayer.onLoad=makeSubBox;
 ref.boxLayer.onMouseOver = boxSlowVelocity;
 ref.boxLayer.onMouseOut = boxSpeedVelocity;
 ref.boxLayer.parent = ref;
}

function boxDrag(e) {
/*
 Called when a drag is in process. Moves the ticker vertically and slides
 it horizontally. Wont allow vertical repositioning if the verticalLock is on.
 also makes sure that you don't vertically reposition the ticker outside the 
 window. It also checks to see if it needs to reposition the clone tape relative
 to the active tape.
*/
   if (!this.parent.parent.horizontalLock) this.parent.moveBy(e.pageX-oldX,0);
   this.layers[0].moveBy(0,e.pageY-oldY);
   this.layers[1].moveBy(0,e.pageY-oldY);
   if (this.parent.left < 0) this.parent.moveTo(0,this.parent.top);
   if (this.parent.left > window.innerWidth-this.parent.clip.width) this.parent.moveTo(window.innerWidth-this.parent.clip.width,this.parent.top);

 if ((this.parent.top>0)&&(this.parent.parent.activeBox.top>0) && 
	(this.parent.parent.nonActiveBox.top > (this.parent.parent.activeBox.top-this.parent.parent.activeBox.clip.height))) {
 		this.parent.parent.nonActiveBox.moveTo(0,this.parent.parent.activeBox.top-this.parent.parent.activeBox.clip.height);
	}
 if ((this.parent.parent.activeBox.top<0)&&(this.parent.parent.activeBox.top+this.parent.parent.activeBox.clip.height<(this.parent.parent.height))) {
 		this.parent.parent.nonActiveBox.moveTo(0,this.parent.parent.activeBox.top+this.parent.parent.activeBox.clip.height);
	}

   oldX = e.pageX;
   oldY = e.pageY;
}

function boxBeginDrag(e) {
/*
 Called when a drag event first happens. Routes off any events occuring to
 a link. Grabs the current time to use later for velocity calculation. 
 Begins trapping mousemove events. Initializes the drag vars.
*/
  
   if (e.target.constructor == window.Url) return routeEvent(e);
   startDragTime = new Date();
   this.parent.parent.stop();
   this.captureEvents(Event.MOUSEMOVE);
   this.onmousemove=boxDrag; 
   oldX=e.pageX;
   oldY=e.pageY;
   startX=e.pageX;
   startY=e.pageY;
   return false;
}

function boxDrop(e) {
/*
 Called when a drag event ends and the ticker is dropped. Routes off any
 events occuring to a link. Grabs the current time, and uses the elapsed
 time of the drag in conjunction with the distance of the drag to determine
 average velocity in pixels per second. It makes sure velocity lock is not
 on before applying the new velocity. When applying, it divides the 
 velocity by 4, because the mouseover event has put velocity to 50% already,
 and also because people drag things too darn fast. If event happens to the 
 right mouse button (3) it doesn't start the ticker again, because the
 right mouse button is the "stop" button.
*/

 if (e.target.constructor == window.Url) return routeEvent(e);
 endDragTime = new Date();
 dragDuration = (endDragTime.getTime() - startDragTime.getTime())/1000;
 dragDistance = e.pageY - startY;

 if (dragDistance > -2 && dragDistance < 2) {
     this.releaseEvents(Event.MOUSEMOVE);
     if (e.which == 1) {
		this.parent.parent.stopped = false;
		this.parent.parent.start();
		}
     if (e.which == 3) this.parent.parent.stopped = true;
     return false;
     }

 dragAverageVelocity = dragDistance/dragDuration;
 this.onmousemove=0; 
 this.releaseEvents(Event.MOUSEMOVE);

   if (!this.parent.parent.velocityLock) this.parent.parent.velocity = Math.round(dragAverageVelocity/4);
   else {
	 if (this.parent.parent.velocity<0 && dragAverageVelocity>0) this.parent.parent.velocity *= -1;
	 if (this.parent.parent.velocity>0 && dragAverageVelocity<0) this.parent.parent.velocity *= -1;
   	 }

   if ((this.parent.parent.velocityMinimum) && 
	Math.abs(this.parent.parent.velocity) < this.parent.parent.velocityMinimum) {
         if (this.parent.parent.velocity < 0) this.parent.parent.velocity = -1*(this.parent.parent.velocityMinimum/2);
         if (this.parent.parent.velocity > 0) this.parent.parent.velocity = (this.parent.parent.velocityMinimum/2);
         }

   if ((this.parent.parent.velocityMaximum) &&
	Math.abs(this.parent.parent.velocity) > this.parent.parent.velocityMaximum) {
         if (this.parent.parent.velocity < 0) this.parent.parent.velocity = -1*(this.parent.parent.velocityMaximum/2);
         if (this.parent.parent.velocity > 0) this.parent.parent.velocity = (this.parent.parent.velocityMaximum/2);
         }
   if (e.which == 1) {
	this.parent.parent.stopped = false;
	this.parent.parent.start();
	}
   if (e.which == 3) this.parent.parent.stopped = true;
   return false;
}

function NewsBox(left,top,width,height,src,velocity) {
/*
 Object stuff. Creates references to all the necessary properties and
 methods, creates the container layer and then calls the functions to
 create the active tape, the clone tape, which in turn calls the 
 start() method here when everything has loaded sequentially. Sets initial
 values to some vars. 
*/

 this.src = src;
 this.left = eval(left);
 this.top = eval(top);
 this.width = eval(width);
 this.height = eval(height);
 this.velocity = eval(velocity);
 this.horizontalLock = false;
 this.velocityLock = false;
 this.velocityMinimum = null;
 this.velocityMaximum = null;
 this.start = startBox;
 this.stop = stopBox;
 this.stopped = false;
 this.container = new Layer(width)
 this.container.left = eval(left);
 this.container.top = eval(top);
 this.container.clip.width= eval(width);
 this.container.clip.height= eval(height);
 this.container.visibility = "show";
 this.container.parent = this;
 this.container.onLoad = makeBox(this);
 this.container.document.parent = this.container;
 this.container.document.captureEvents(Event.MOUSEDOWN | Event.MOUSEUP);
 this.container.document.onmousedown=boxBeginDrag;
 this.container.document.onmouseup=boxDrop;
}

