#! /usr/local/bin/perl

#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
# 
# Permission to use, copy, modify and distribute without fee any portion 
# of this software and its documentation, for any purpose, is hereby granted 
# without fee, provided that (i) the above copyright notices and this 
# permission notice appear in all copies of the software and related 
# documentation, and (ii) the name of Ian Graham and The University of 
# Toronto may not be used in any advertising or publicity relating to 
# the software without the specific, prior written permission of Ian Graham.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
# 
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
#
# notice_poster.pl
#
# Revision:  1.0
# Date:      8 January 1995
# Author:    Ian Graham <ian.graham@utoronto.ca>

# This program scans the seminar notices database directory and posts
# the contents of "new" notices to Usenet newsgroups designated in the 
# administrative database file $db_b_file.  Messages are crossposted if
# posted to more than one group.

# This program defines "new" notices as any database entry that has been
# created or modified within the previous 24 hours.  

# Use DEBUG to set debug mode:  

#$DEBUG = 1;   

require '../cgi-reg/lib/configure.ph';        # Configuration parameters
require '../cgi-reg/lib/read_db_file.pl';     # Read database file 
require '../cgi-reg/lib/utils.pl';            # Error output/misc. utilities
require '../cgi-reg/lib/create_text_notice.pl';# subroutine to generate notice
require './config_cron.ph';


&get_group_info($db_file, *dept_file);        # Read department database.
					      # %dept_file contains full names
					      # of each department, indexed
					      # by short-string keys.
foreach $dept_key (keys(%dept_file)) {
   &scan_db_file($db_b_file,$dept_key, *division_keys,
	         *user_id, *listserv, *newsgrps);
     
   foreach( @division_keys ) {
      $listservs{$dept_key."+".$_} = $listserv{$_};
   }
}

if($DEBUG) {
  foreach (keys(%listservs) ) {
     print "Key=$_,     Content=$listservs{$_}\n";
  }
}

if( !opendir(DIR, $notice_dir)) {
  die "Unable to open notices directory $notice_dir\n"; 
}
@tmp = readdir(DIR);
foreach (@tmp) {
  push(@filenames,$_) if -T $notice_dir."/".$_;
}
close(DIR);

@filenames = sort(@filenames);                # list of all valid entries
$line_width = 80;

foreach (@filenames ) {
   $fname =  $notice_dir."/".$_;
   next if -M $fname > 1.0;                   # skip it if file is > 1 day old
   &read_db_file($fname, *array);             # Read db_file (to %array)
   next if ($array{"modified"} eq "moved" || $array{"modified"} eq "cancelled")  
   @page=();
   &create_text_notice($line_width, *dept_file, *array, *page, *subject);
   $news_list = $listservs{$array{"dept"}."+".$array{"organ_type"}};
   $news_list =~ s/ */,/g;

FORK:{      
   close(READ_SIDE); 
   close(WRITE_SIDE);
   pipe(READ_SIDE, WRITE_SIDE);
   if( $pid = fork() ) {             # != 0 means parent 0=child
	   close(READ_SIDE);
	   select(WRITE_SIDE); $|=1;
	   print WRITE_SIDE "@page";
	   close(WRITE_SIDE);            # indicates EOF to child.
	   select(STDOUT);
	   print STDOUT "PARENT -- after forking....\n";
	   sleep 5;                     
   } elsif (defined $pid) {          # pid=0 indicates child.
	   close(WRITE_SIDE);
	   close(STDIN);
	   open(STDIN, "<&READ_SIDE");   # redirect READ_SIDE to STDIN;
					 # exec mail program using STDIN
					 # as mailed message.
	   exec "/usr/inews -f \"UofT Seminar Notice System\" -t \"$subject\" -n $news_list <&0";
	   die;
   } elsif ($! =~ /No more process/ ) {
	                               # no more process:  sleep and retry
	   sleep 5;
	   redo FORK;
   } 
   else {                          # Undefined Fork Error;
	   die "Undefined Fork error in __FILE__ at line __LINE__\n";
   } 
 }  
}
