#! /usr/local/bin/perl
#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
#
# Permission to use, copy, modify and distribute without fee any portion
# of this software and its documentation, for any purpose, is hereby granted
# without fee, provided that (i) the above copyright notices and this
# permission notice appear in all copies of the software and related
# documentation, and (ii) the name of Ian Graham and The University of
# Toronto may not be used in any advertising or publicity relating to
# the software without the specific, prior written permission of Ian 
# Graham.
#
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
#
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
# mail_week.pl
#
# Revision:  1.0
# Date:      8 January 1995
# Author:    Ian Graham <ian.graham@utoronto.ca>
#
# This program scans the notices database and  processes those notices 
# scheduled for a given time interval, as specified by command-line 
# arguments. If the group posting the notice has an associated mailing list
# or lists, the notice is appended to temporary files appropriate to the 
# mailing list(s). When all notices have been processed, these temporary 
# files are mailed to the appropriate listserv addresses,  with an 
# appropriate subject heading.
# 
# Notices are *not* posted if they correspond to moved or cancelled events 
# -- in these cases the moved event has a separate notices entry, and only 
# this entry is posted. Cancelled events, however, are posted.  

# Use DEBUG to set debug mode:  

#$DEBUG = 1;   

require "getopt.pl";
require "timelocal.pl";
require '../cgi-reg/lib/configure.ph';         # Global configuration 
require './configure.ph';                      # Local configuration 
require '../cgi-reg/lib/read_db_file.pl';      # Read database file 
require '../cgi-reg/lib/utils.pl';             # Error output/misc. utilities
require '../cgi-reg/lib/create_text_notice.pl';# subroutine to generate notice
require '../cgi-reg/lib/time_interval_abs.pl'; # get filenames for allowed files
require '../cgi-reg/lib/isotoasc.pl';          # conversion to ASCII
require './config_cron.ph';
require './lib/utils.pl';
require './lib/extract_short_entry_list.pl';

select(STDOUT); 
$|=1;

&Getopt('sl');

if ( !defined($opt_s) || !defined($opt_l) ) {
       print STDERR "Usage: $0  -s start_time  -l length(days) \n";
       print STDERR "       (start_time = n - day relative to current day, >0 ";
       print STDERR "(1 == today))\n"; 
       print STDERR "       (length     = m - days after start day        >=0 ";
       print STDERR "(6 == 1 week))\n"; 
       die;
 }


$start   = $opt_s;  # Mail out notices that will take place during 
$length  = $opt_l;  # the time interval $start + $length
                    

# get mapping between listservs (keys) and dept:group names (values)
# The two returned arrays are:
#
# $listservs{"list"}             = "dept1:group1 dept2:group2 ..."
# $dept_group_list{"dept:group"} = "list1 list2 ..."

&get_listserv_map(*dept_list, *listservs, *dept_group_list);  

foreach (keys(%listservs)) {
   $list_flag{$_} = 0;                     # This is a toggle for listservs 
}					   # that are actually used. Set 
					   # to 1 when there is data to send
					   # to this list.
   

&create_tmp_files(*listservs, *tmp_files); # create temporary files for
					   # holding listserv mailings:
                                           # filename = $tmp_files{"list_name"}

# Now, given the start and stop time, determine the 
# start and stop filenames, and the actual corresponding
# starting and stoppind dates/times. If an error, then
# say so, and quit.


if(!(&time_interval_abs($start,       $length,
                        *fname_start, *date_start,
                        *fname_stop,  *date_stop, *error)) ) {
    &mf_error($error, __FILE__, __LINE__);
}

&get_filenames(*filenames) ;              # get names of notices files 
					  # (without directory information)

                                          # If notice is for an event in
					  # the desired interval, then create
					  # the full filename, open then entry,
					  # and test to see if there is an
					  # associated mailing list.
foreach $file (@filenames) {
  if($DEBUG) { print "file = $file"; }
  if( ($file gt $fname_start) && ($file lt $fname_stop) )  {
     $full_file = $notice_dir."/".$file;
     if($DEBUG) { print " --> Extract: $file\n"; }
     @entry = ();
					  # The following subroutine tests 
					  # to see if the notice has
					  # associated mailing lists.. If not,
					  # then it returns a null $entry.

     $flag = &extract_short_mail_entry($full_file,       *dept_list, 
				       *dept_group_list, *dept_group, 
				       *entry );
     if($flag ne "false" )  {
        if ($DEBUG) { print "... NON-BLANK entry...\n"; }
	@lists  = split(/ +/,$dept_group_list{$dept_group});
        if ($DEBUG) { 
	      print "......  Sending to lists: ";
	      foreach $foo (@lists) { print "                 $foo,\n"; }
        }
	foreach $list (@lists) {
	    if($list_flag{$list} == 0) {
		$tmpfile = $tmp_files{$list};
		&write_list_header($list, $tmp_files{$list},
				   $date_start, $date_stop);
		$list_flag{$list} = 1; 
            }
	    &write_list_entry($list, $tmp_files{$list}, *entry);
	}
     }
     else {
       if ($DEBUG) { print "   ... BLANK entry -- do not add to list \n\n"; }
     }
  }
  else {
     if ($DEBUG) { print " --> Not Extracting -- wrong time/date\n"; }
  }
}


print " STDERR -- OK: now mail the suckers ..... \n";
foreach $list (keys(%listservs)) {
    print STDERR " STDERR -- List = $list\n";
    if( $list_flag{$list} == 1) {
	$subject = "UPCOMING EVENTS: $date_start to $date_stop";
	$string = "/usr/ucb/mail -s \"$subject\" $list < $tmp_files{$list}";
 	system ($string);
    }
    else {
        print STDERR " STDERR -- Nothing to mail to this list....\n";
    }
}
&delete_tmp_files(*tmp_files);
