#! /usr/local/bin/perl

{

}


sub get_listserv_map

{
   local (*dept_list, *listservs, *dept_group_lists) = @_;
   local (@depts);
   local (@div_keys,  %user_id, %lists, %newsgrps );
   local (@tmp,       $tmp, $list, $news, $term);

   %listservs        = ();
   %dept_group_lists = ();

   open(LIST_DB, "<$lists_file") ||
      &mf_error("Unable to open listservs database file -:$lists_file:", __FILE, __LINE__);
      while(<LIST_DB>) {
          s/[\s\t\r ]*//g;             # convert tabs to single space
          if( !(/^ *#/)  && /\S/ ) {   # skip comment lines
             $listservs{$_}="";        # initialize associative array key
          }
      }
   close(LIST_DB);

   if($DEBUG) { print "Listservs are\n"; }
   if($DEBUG) { foreach (keys(%listservs)) { print " ... $_ \n";} }
   

   &get_group_info($db_file, *dept_list);

   foreach $dept (keys(%dept_list)) {
       @div_keys = ();
       %user_id  = ();
       %lists    = ();
       %newsgrps = ();
       &scan_db_file($db_b_file, $dept, *div_keys, *user_id, *lists, *newsgrps);
       if($DEBUG) { print "DEPT = $dept .....\n"; }
       foreach (@div_keys) {
	  $_ =~ s/^ *//;
	  $_ =~ s/ *$//;
	  $_ =~ s/ +/ /g;
	  $_ =~ s/ /_/g;
	  $dept_group = $dept.":".$_;
	  if( !defined($dept_group_lists{"$dept_group"}) ) {
	      $dept_group_lists{"$dept_group"} = "";
          }
          if($DEBUG) { print "   dept:group = $dept_group .....\n"; }
       }
       foreach (keys(%lists)) {
	  $list = $lists{$_};
	  $list =~ s/[\,\;\:]*//g;
	  $list =~ s/ +/ /g;
	  @list = split(" ",$list);
	  $_ =~ s/ /_/g;
	  $tmp  = " ".$dept.":".$_;    
	  if( $list =~ /\S/ ) {
	     foreach $term (@list) {
	         $listservs{$term}  .= $tmp;
             }
          }
       }
   }
   if($DEBUG) {
      print "\n\n Listservs --> dept:group mappings\n";
      foreach (keys(%listservs)) {
	    print "List = $_ \t  Dept:group(s) = -:$listservs{$_}:-\n";
      }
   }
# reverse list so that we have:
# dept_group_list{"dept:group"} = "list1 list2"

   foreach $list (keys(%listservs)) {
       if( $listservs{$list} ne "")  {
	  $listservs{$list} =~ s/^ +//;
	  $listservs{$list} =~ s/ *$//;
	  @tmp = split(/ +/, $listservs{$list});
	  foreach $tmp (@tmp) {
	     $tmp =~ s/ +//g;
	     $dept_group_list{$tmp} .= $list." ";
          }
       }
   }
   if($DEBUG) {
      print "\n\n Dept:group --> listserv mappings\n";
      foreach (keys(%dept_group_list)) {
	    print "dept_group = $_ \t  List(s) = -:$dept_group_list{$_}:-\n";
      }
   }
}

sub get_newsgroup_map

{
   local (*dept_list, *newsgroups, *dept_group_news) = @_;
   local (@depts);
   local (@div_keys,  %user_id, %lists, %newsgrps );
   local ($tmp, @tmp, $list, $news);

   %newsgroups = ();

   open(LIST_DB, "<$news_file") ||
      &mf_error("Unable to open listservs database file -:$lists_file:", __FILE__, __LINE__);
      while(<LIST_DB>) {
          s/[\s\t\r ]*//g;             # convert tabs to single space
          if( !(/^ *#/)  && /\S/ ) {   # skip comment lines
             $listservs{$_}="";        # initialize associative array key
          }
      }
   close(LIST_DB);
   
   &get_group_info($db_file, *dept_list);

   foreach $dept (keys(%dept_list)) {
       @div_keys = ();
       %user_id  = ();
       %lists    = ();
       %newsgrps = ();
       &scan_db_file($db_b_file, $dept, *div_keys, *user_id, *lists, *newsgrps);
       if($DEBUG) { print "\n\nDEPT = $dept .....\n"; }
       foreach (keys(%newsgrps)) {
	  $list = $newsgrps{$_};
	  $list =~ s/[\,\;\:]*//g;
	  $list =~ s/ +/ /g;
#	  print " list = .... $list\n";
	  @list = split(" ",$list);
	  $_ =~ s/ /_/g;
	  $tmp  = " ".$dept.":".$_;    
	  if( $list =~ /\S/ ) {
	     foreach $term (@list) {
	         $newsgroups{$term}  .= $tmp;
             }
          }
       }
   }
# reverse list so that we have:
# dept_group_news{"dept:group"} = "news1 news2"

   foreach $news (keys(%newsgroups)) {
       if( $newsgroups{$news} ne "")  {
	  $newsgroups{$news} =~ s/^ +//;
	  $newsgroups{$news} =~ s/ *$//;
	  @tmp = split(/ +/, $newsgroups{$news});
	  foreach $tmp (@tmp) {
	     $tmp =~ s/ +//g;
	     $dept_group_news{$tmp} .= $news." ";
          }
       }
   }
}

sub create_tmp_files {

# This subroutine takes the list of  newsgroups and creates filenames 
# of the form 
#
#                  TMPDIR/$listname.PID
#
# Where TMPDIR is the path to the TMP dir, and PID is the process ID
# of the current process. The list of filename is returned in the
# associative array 
#
#                  %tmp_files{listname} = FILENAME
#
# This routine "touches" the files, to ensure that the filesa are created 
# and ready for use. 
#
# The umask is set to 077 to ensure that the web daemon is the only 
# allowed editor of the files.
 
   local(*listservs, *tmp_files) = @_;
   local($tmpdir, $pid);

   %tmp_files = ();

   if( defined($ENV{"TMP"})) {
      $tmpdir = $ENV{"TMP"};
   }
   else {
      if (-d "/usr/tmp") {
	  $tmpdir = "/usr/tmp";
      }
      elsif (-d "/tmp" ) {
	  $tmpdir = "/tmp";
      }
      else {
	 &mf_error("Unable to find tmp directory ",  __FILE__, __LINE__);
      }
   }
   $pid = $$;
   $string = "touch ";
   umask(077);
   foreach (keys(%listservs)) {
      if( $listservs{$_} ne "" )  {
          $file = "$tmpdir/$_.$pid";
          $tmp_files{$_} = $file;
          $string .= $file." ";
          system($string);
      }
   }
}

sub delete_tmp_files {
                                 # This function deletes a list of files,
				 # passed via the array @tmp_files
   local(*tmp_files) = @_;
   local($tmp, $file, $err);

   $tmp = "";

   foreach (keys (%tmp_files)) {
      $file = $tmp_files{$_};        # filename to delete
      $tmp .= $file." ";             # append to list
      if( length($tmp) > 1024 ) {
            system("rm $tmp");       # exec removal if list lengthy; reset list
	    $tmp = "";
      }
   }
   if($tmp =~ /\S/ ) {
      $err = system("rm $tmp");      # delete remaining files
   }
}
       

      
sub get_filenames  {
   local(*filenames) = @_;
   local($tmp, @tmp);
   @filenames = ();
   if( !opendir(DIR, $notice_dir)) {
	&mf_error("Unable to open notices directory $notice_dir", 
		   __FILE__, __LINE__); }
	@tmp = readdir(DIR);
	close(DIR);
	foreach (@tmp) {
	   $tmp = $notice_dir."/".$_;
	   push(@filenames,$_) if -T $tmp;
	}
   @filenames = sort(@filenames);
}


sub mf_error  {
   print STDERR "Program $0 --\n  FATAL ERROR $_[0] \n";
   print STDERR "  Error occurred in file $_[1] at line $_[2]\n";
   die;
}
1;


