#! /usr/local/bin/perl
#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
#
# Permission to use, copy, modify and distribute without fee any portion
# of this software and its documentation, for any purpose, is hereby granted
# without fee, provided that (i) the above copyright notices and this
# permission notice appear in all copies of the software and related
# documentation, and (ii) the name of Ian Graham and The University of
# Toronto may not be used in any advertising or publicity relating to
# the software without the specific, prior written permission of Ian Graham.
#
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
#
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
# cleanup.pl
#
# Revision:  1.0
# Date:      8 January 1995
# Author:    Ian Graham <ian.graham@utoronto.ca>

# This perl checks the seminar notice database entries, and moves expired
# entries into the Expired/ subdirectory.

# Use DeBUG to set debug mode:

# $DEBUG = 1;   # -------- Debug flag  

require '../cgi-reg/lib/configure.ph';
require 'timelocal.pl';
require '../cgi-reg/lib/utils.pl';
require './config_cron.ph';

@char_arr = ("00", "01", "02", "03", "04", "05", "06", "07", "08", "09");
@mon_str = ("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep",
	    "Oct", "Nov", "Dec");

                                   # Access seminar notices database
				   # directory and get a list of all
				   # database files.
if( !opendir(DIR, $notice_dir)) {
	 die "Unable to open notices directory $notice_dir\n"; }
   @tmp = readdir(DIR);
   foreach (@tmp) { 
       push(@filenames,$_) if -T $notice_dir."/".$_;
   }
close(DIR);

@filenames = sort(@filenames);    # Sort filename list in ascending order
				  # recall that the filename contains the date.

                                  # Get current date
($s_sec,$s_min,$s_hour,$s_mday,$s_mon,$s_year,$s_wday,$s_yday,$s_isdst)
       = localtime(time());

				  # Convert to 4 digit year
$s_year     += ($s_year < 70) ? 2000 : 1900;    
$s_mon       = $char_arr[$s_mon]   if $s_mon    < 10;
$s_mday      = $char_arr[$s_mday]  if $s_mday   < 10;
$fname_bound = $s_year.$s_mon.$s_mday."-9999.9999";

				  # Move expired notices to the 
				  # Expired directory. Archive them by Year
				  # and Month
# print "Filename Bound = $fname_bound\n\n";
foreach $file (@filenames) {
  if( $file lt $fname_bound )   {
     $tmp  = $notice_dir."/".$file;
     $year = $file;
     $year =~ s/(....).*/$1/;
     $month = $file;
     $month =~ s/....(..).*/$1/;
     $month = $mon_str[$month];
     $path = $notice_dir."/Expired/".$year;
     if( !(-d $path) ) {
	 if( !mkdir($path, 0755) ) {
           die "Unable to Create Directory in __FILE__ at line __LINE__\n";
         }
     }
     $path = $path."/".$month;
     if( !(-d $path) ) {
	 if( !mkdir($path, 0755) ) {
           die "Unable to Create Directory in __FILE__ at line __LINE__\n";
         }
     }
     $tmp2 = $path."/".$file;
     system("/bin/mv $tmp $tmp2");
  }
}
