#!/bin/sh
#
# First-pass Installer, as a Bourne Shell program. This program checks that
# it has found the correct version of perl -- Perl, Version 4, and if so 
# runs the perl installer program install.pl. If it detects some other
# version of Perl (typically Version 5) it provides alternative instructions
# to the user.

string=`eval which perl`
if test -f $string
then
  echo 
  echo 
  echo "Good. You have perl.  Now I'll make sure you have the right version...."
  echo 
  string2=`$string -v`
  string3=`echo $string2 | \
       awk '/This is perl, version/ { print substr($5,1,1) }'`
  if test "$string3" = 5
  then 
     echo "I have detected Perl Version 5, located at $string."
     echo
     echo "Unfortunately, this package only runs under Perl Version 4."
     echo "If you also have perl Version 4, you can edit this script and"
     echo "explicitly replace the first line to point directly to"
     echo "your perl 4 executable: that is, change the line:"
     echo 
     echo "      string=\`eval which perl\`"
     echo 
     echo "to:"
     echo 
     echo "      string = \"/path/to/perl4\""
     echo ""
     echo "Where /path/to/perl is the full path down to your perl 4 executable."
     echo ""
     echo "If your system does not have perl version 4, you can easily"
     echo "obtain and install the software -- your system can support"
     echo "both perl 4 and perl 5 at the same time, by providing different"
     echo "names for the executable and by placing the associated libraries"
     echo "in different directories."

     echo "Perl version 4 can be obtained from many places. For example:"
     echo ""
     echo "     ftp://prep.ai.mit.edu/pub/gnu/perl-4.036.tar.gz"
     echo ""
     exit 1
  else 
     echo "Even better -- I have detected Perl Version 4."
     echo 
  fi 
  echo "I am now running the perl program install.ph"
  echo 
  echo
   $string install.pl $string <&0 
else
   echo "You must install perl Version 4 (or have perl 4"
   echo "in your path) before installing this package."
fi
