# Configure.ph -- General -purpose Configuration file 


# You will need to modify the entries down to the indicated line.

# The system needs to know the name and contact information for the
# person who will manage the notices system. This information must be
# entered here.

$notice_manager_name = "Ian Graham";
$email_address       = "ian.graham@utoronto.ca";
$phone_number        = "(416) 978-4548";


# $http_server_and_port --------------------------------------------------
#          The domain name and port number for the HTTP server supporting
#          the seminar system.  This is in the URL syntax - note there is
#          NO trailing slash....

$http_server_and_port = "http://www.utoronto.ca:4111";


# $documents   --------------------------------------------------
#          The root directory for the webnotice documentation -- this must
#          lie in the server's document directory. The actual documentation
#          is installed in $doc_install_root.$version, where $version
#          is the software version number -- the installer will symlink
#          the name $doc_install_root to this installation directory.

$documents = "/homes/wnotice/www-data/docs";


# $rel_doc_dir -----------------------------------------------------------
#          Documentation directory relative to the root of the HTTP server 
#          document directory.  This is used to construct URLs that point 
#          to the desired HTML document.  The leading slash is requried.

$rel_doc_dir  = "/wnotice/docs/";


# $package ---------------------------------------------------------
#          The root directory for  the webnotice software. The actual
#          software is installed in $package_root.$version, where $version
#          is the software version number -- the installer will symlink
#          the name package_root to this installation directory.

$package     = "/homes/wnotice/Webnotice";

# -------------------------------------------------------------------
# YOU WILL NEED TO MODIFY THE NEXT THREE ITEMS *ONLY* IF YOU ARE ----
# INSTALLING MORE THAN ONE WEBNOTICE PACKAGE ON THE SAME MACHINE ----
# -------------------------------------------------------------------

# $rel_cgi_dir ------
#          The relative path to the installed *non-secure* perl 
#	   programs, as seen by the HTTP server This is usually 
#	   just "/cgi-reg/" 

$rel_cgi_dir = "/wreg/";    

# $rel_secure_cgi_dir ------
#          The relative path to the installed *secure* perl programs, 
#          as seen by the HTTP server This is usually just 
#          "/cgi-secure/" 

$rel_secure_cgi_dir = "/wsecure/";    

# $rel_admin_cgi_dir ------
#          The relative path to the installed adminstrative perl programs, 
#          as seen by the HTTP server This is usually just 
#          "/admin/" 

$rel_admin_cgi_dir = "/wadmin/";    


# -------------------------------------------------------------------
# ****   YOU SHOULD NOT NEED TO MODIFY ANYTHING BELOW THIS LINE  ****
# -------------------------------------------------------------------

$version = "-1.1/";

$package_dir     = $package.$version;
$doc_install_dir = $documents.$version;

$data_dir        = $package_dir."Templates/";    # Where to store templates
$notice_dir      = $package_dir."notices/";      # Directory for stored notices
$db_dir          = $package_dir."db_dir/";       # Directory for config files.

$abs_cgi_dir     = $package_dir."notice_prgms";  # Directory for programs
$logs_file_dir   = $package_dir."logs";          # Directory for log files


# Raw names for the template documents and the configuration database file:

$notices_main_tmpl        = "notices_main.tmpl";  # Home page for seminar system
$add_notice_tmpl          = "add_notice.tmpl";    # add a seminar notice
$deposit_form_tmpl        = "deposit_form.tmpl";  # fill-in FORM template
$display_notice_tmpl      = "display_notice.tmpl";# full notice display
$check_notice_tmpl        = "check_notice.tmpl";  # seminar notice verification 
$admin_main_tmpl          = "admin_main.tmpl";
						

$view_notice_tmpl         = "view_notice.tmpl";   # retrieve & view notices
$view_notice_bygroup_tmpl = "view_notice_bygroup.tmpl"; #retrieve & view notices
$modify_notice_tmpl       = "modify_notice.tmpl"; # modify notices
$cancel_notice_tmpl       = "cancel_notice.tmpl"; # cancel notices
$delete_notice_tmpl       = "delete_notice.tmpl"; # delete notices
$modify_form_tmpl         = "modify_form.tmpl";   # modify notices form
$check_modify_notice_tmpl = "check_modify_notice.tmpl"; 
						  # check modified notices
$check_cancel_notice_tmpl = "check_cancel_notice.tmpl";    
						  # check cancelled notices
$check_delete_notice_tmpl = "check_delete_notice.tmpl";    
						  # check deleted notices


# Set Names for main database files 
$db_file                  = "seminar.conf";       # name for main database file
$db_b_file                = "seminar-2.conf";     # name for secondary db file
$lists_file               = "listservs.conf";     # list of supported listservs
$news_file                = "newsgroups.conf";    # list of supported listservs

# Names for realms for HTTP authentication:

$adm_realm                = "SuperPasswds";       # For superusers/admin
$reg_realm                = "RegPasswds";         # For regular users

# Create root URL pointing to the seminar gateway program directory --

$cgi_dir               = $http_server_and_port.$rel_cgi_dir;
$secure_cgi_dir        = $http_server_and_port.$rel_secure_cgi_dir;
$adm_cgi_dir           = $http_server_and_port.$rel_admin_cgi_dir;

# Create full pathnames to template files and to configuration database --

$notices_main_tmpl          = $data_dir.$notices_main_tmpl; 
$add_notice_tmpl            = $data_dir.$add_notice_tmpl;
$deposit_form_tmpl          = $data_dir.$deposit_form_tmpl;
$display_notice_tmpl        = $data_dir.$display_notice_tmpl;
$check_notice_tmpl          = $data_dir.$check_notice_tmpl;
$view_notice_tmpl           = $data_dir.$view_notice_tmpl;
$view_notice_bygroup_tmpl   = $data_dir.$view_notice_bygroup_tmpl;
$modify_notice_tmpl         = $data_dir.$modify_notice_tmpl;
$modify_form_tmpl           = $data_dir.$modify_form_tmpl;
$cancel_notice_tmpl         = $data_dir.$cancel_notice_tmpl;
$delete_notice_tmpl         = $data_dir.$delete_notice_tmpl;
$check_modify_notice_tmpl   = $data_dir.$check_modify_notice_tmpl;    
$check_cancel_notice_tmpl   = $data_dir.$check_cancel_notice_tmpl;    
$check_delete_notice_tmpl   = $data_dir.$check_delete_notice_tmpl;    
$admin_main_tmpl            = $data_dir.$admin_main_tmpl;

#Database files
$db_file               = $db_dir.$db_file;
$db_b_file             = $db_dir.$db_b_file;
$lists_file            = $db_dir.$lists_file;
$news_file             = $db_dir.$news_file;

# Create full pathname to seminar notice database directory --

# List all possible types of notices, and add them to an array

$event_type[0] = "Seminar";
$event_type[1] = "Colloquium";
$event_type[2] = "Lecture";
$event_type[3] = "Exhibition";
$event_type[4] = "Meeting";
$event_type[5] = "Conference";
$event_type[7] = "Music";
$event_type[6] = "Miscellaneous";

$TRUE  = 1;
$FALSE = 0;

1;
