#! /usr/local/bin/perl

#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
# 
# Permission to use, copy, modify and distribute without fee any portion 
# of this software and its documentation, for any purpose, is hereby granted 
# without fee, provided that (i) the above copyright notices and this 
# permission notice appear in all copies of the software and related 
# documentation, and (ii) the name of Ian Graham and The University of 
# Toronto may not be used in any advertising or publicity relating to 
# the software without the specific, prior written permission of Ian Graham.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
# 
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
#
# modify_notice.pl
#
# Ian Graham <ian.graham@utoronto.ca>, Jan 1995
#

require    '../cgi-reg/lib/configure.ph';
require    '../cgi-reg/lib/utils.pl';
require    '../cgi-reg/lib/create_form.pl';
require    '../cgi-reg/lib/read_db_file.pl';
require    'lib/write_db_entry.pl';
require    'lib/construct_entry.pl';
require    'lib/is_user_authorized.pl';

#$DEBUG=1;

if( $DEBUG) {print "Content-type: text/plain\n\n"; }
if( $DEBUG) {print "DEBUG ....\n"; }


$new_depositor   = $ENV{"REMOTE_USER"};    # User ID depositing the Notice
$new_remote_host = $ENV{"REMOTE_HOST"};    # Domain name of depositing machine
$new_remote_addr = $ENV{"REMOTE_ADDR"};    # IP address of depositing machine

&get_group_info($db_file, *dept_list);

$input=<STDIN> ||
     &f_error("Fatal error -- No input data\n", __LINE__, __FILE__);

$input =~ s/\s*$//;                        # chop off trailing whitespace
# chop($input); chop($input);              # chop CR/LF trailing characters 
@fields=split("&",$input);               # split data into separate fields 

foreach $one (@fields) { 
   ($name, $value) = split("=",$one);
   $name =~ s/\+/ /g;                      # convert +'s to spaces
   $name  =~ s/%(..)/pack("c",hex($1))/ge; # convert URL hex codings to Latin-1
   $value =~ s/\+/ /g;                     # convert +'s to spaces
   $value =~ s/%(..)/pack("c",hex($1))/ge; # convert URL hex codings to Latin-1

   $value =~ s/^\s*//;                   # remove leading whitespace chars
   $value =~ s/\s*$//;                   # remove trailing whitespace chars
   $value =~ s/%22/"/g;                  # convert encoded quotes to quotes
   $value =~ s/%3e/>/g;                  # convert encoded > to >

   $new_array{"$name"} = $value;         # Place content in form field array
}

&is_user_authorized($db_b_file, $new_array{"dept"}, 
		    $new_array{"organ_type"}, $new_depositor);


#  determine time that the seminar was deposited

foreach (localtime(time))  {
   $loc_time .= ($_." ");
}

if( $DEBUG) { 
    @tmpp = localtime(time);
    print "****** >>>>>> localtime = @tmpp\n"; 
    print "****** >>>>>> loc_time = $loc_time\n"; 
}

$new_dep_date             =  $loc_time;
$new_array{"new_entry"}   =  "false";
$new_array{"modified"}    =  "true";

if($new_array{"accept"} eq "yes")  {

  $old_file = $notice_dir."/".$new_array{"old_file_name"};
  &read_db_file($old_file, *old_array);

  $new_array{"depositor"}   = $old_array{"depositor"}." : ".$new_depositor;
  $new_array{"remote_host"} = $old_array{"remote_host"}." : ".$new_remote_host;
  $new_array{"remote_addr"} = $old_array{"remote_addr"}." : ".$new_remote_addr;

  if($DEBUG) {
     print "TIME: - OLD / NEW   $old_array{\"time\"}   $new_array{\"time\"}\n";
     print "DATE: - OLD / NEW   $old_array{\"date\"}   $new_array{\"date\"}\n";
  }
  delete $new_array{"dummy"};
  delete $new_array{"accept"};
  if( $old_array{"time"} eq $new_array{"time"} &&
      $old_array{"date"} eq $new_array{"date"} ) {

      if($DEBUG) {print "modifying old entry\n"; }
      $new_array{"modified"}  = "true";
      $new_array{"new_entry"} = "false";
      delete $new_array{"old_file_name"};
      if($DEBUG) {print "Construct new entry\n"; }
      &construct_entry(*entry, *new_array);
      $dept       = $new_array{"dept"};
      $organ      = $new_array{"organ_type"};
      $department = $dept_list{$dept};
      if($DEBUG) {print "New Entry Constructed\n"; }
      &modify_db_entry($old_file,   $dept,
		       $department, $organ,
		       *entry,      *comments);
      if($DEBUG) {print "New modifications deposited\n"; }

      &print_page(*comments);
   
  }
  else {
     
      $new_array{"link_from"} = $new_array{"old_file_name"};
      delete $new_array{"old_file_name"};
      &construct_entry(*entry2, *new_array);
      &write_db_entry($notice_dir, $new_array{"time_date_string"}, 
                      $dept,       $department,
		      $organ,      *entry2, 
		      *comments,   *new_file_name);

			       # modify the old entry...
      $old_array{"modified"}  = "moved";
      $old_array{"new_entry"} = "false";
      $old_array{"link_to"}   = $new_file_name;
      $old_array{"new_time"}  = $new_array{"time"};
      $old_array{"new_date"}  = $new_array{"date"};

      delete $old_array{"dummy"};

         $old_array{"locat"} =
         "** MOVED TO ** "."<a href=\"".$rel_cgi_dir."list_full.pl?".$new_file_name."\">$new_array{\"date\"} at $new_array{\"time\"}</A>";


      @comments= ();                        # re-initialize array
      &construct_entry(*entry, *old_array);
      $dept       = $new_array{"dept"};
      $organ      = $new_array{"organ_type"};
      $department = $dept_list{$dept};
      &modify_db_entry($old_file,   $dept,
		       $department, $organ,
		       *entry,      *comments);

      &print_page(*comments);

  }
}
else {
  $hidden  =  
  "<INPUT TYPE=\"hidden\" NAME=\"dept\" VALUE=\"$new_array{\"dept\"}\">\n";
  $hidden .=
  "<INPUT TYPE=\"hidden\" NAME=\"old_file_name\" VALUE=\"$new_array{\"old_file_name\"}\">\n";
  $department = $dept_list{$new_array{"dept"}};
  push(@form_err,
   "<hr><p>");
  push(@form_err,
   "<h2>*** Modification Interrupted ***</h2><p>You selected <b><i>no</i></b>");
  push(@form_err,
   "(or failed to select yes) before pressing the <i>submit</i> button.\n");
  push(@form_err,
   "<p>You can contine to make\n");
  push(@form_err,
   "changes to the posting by editing the form below. Alternatively you\n");
  push(@form_err,
   "can go back to the Home page of the notices system by pressing\n");
  push(@form_err,
   "<a href=\"$rel_cgi_dir"."notices_main.pl\">here</a>.<hr>\n");

  &create_form($deposit_form_tmpl,$department,$hidden,*form_err,*new_array,*form);
  &print_page(*form);
}

