#! /usr/local/bin/perl


{
}
# Subroutines 
#    write_db_entry(), modify_db_entry(), and cancel_db_entry {()
#
# Author:  Ian Graham   <ian.graham@utoronto.ca>
# Date:    18 April 1995
#
# PURPOSE
#   This collection of subroutines is used to make modifications to 
#   seminar notice database entries.  Write_db_entry() is used to
#   create a new entry, and uses a time-date algorithm to create a 
#   unique filename, based on the time and date the entry is deposited.
#   In all three cases the data to be placed in the database file is 
#   passed from the calling program via the array @entry.

sub write_db_entry {

    local($notice_dir, $time_date_string, $dept, $department, 
	  $organ, *entry, *comments, *file) = @_;

    local($year, $month, $day, $hour, $min, $sec, $pid);
    local(@day_arr, @hour_arr, @min_arr);

    @char_arr = ("00", "01", "02", "03", "04", "05", "06", "07", "08", "09");

    ($year,$month,$day,$hour,$min,$sec) = split(/ /,$time_date_string);

    $month = $char_arr[$month] if $month < 10;
    $day   = $char_arr[$day]   if $day   < 10;
    $hour  = $char_arr[$hour]  if $hour  < 10;
    $min   = $char_arr[$min]   if $min   < 10;

    $pdate_time = $year.$month.$day."-".$hour.$min;
    $pid        = $$;
    $filename   = $notice_dir."/".$pdate_time.".".$pid;

    if( $DEBUG) {print "-- Pdate_time  = $pdate_time\n"; }
    if( $DEBUG) {print "-- filename  = $filename\n"; }

    while( (-e $filename) ) {      # if filename exists, try incrementing pid.

	$pid++;
	$filename = $notice_dir."/".$pdate_time.".".$pid;
        if( $DEBUG) {print "-- filename  = $filename\n"; }
    }

    $file = $pdate_time.".".$pid;
                                   # open the file, and write to it.
    open(FILEOUT, ">$filename")||
		      &f_error("Unable to open $filename for output.\n",__LINE__,__FILE__);
        print FILEOUT @entry;
    close(FILEOUT);

#       Push into array comments to be returned to the user, confirming
#       Deposition of the seminar notice.

    push(@comments,"<HTML><HEAD><TITLE>Notice Succesfully Deposited - $department </TITLE>\n");
    push(@comments,"</HEAD> <BODY> <H2 align=center >Notice Succesfully Deposited  </H2>\n");
    push(@comments,"<H2>$department\n");
    if($organ ne "Department") {
       push(@comments,": <em>$organ</em> </h2>\n");
    }
    else {
       push(@comments,"</h2>\n");
    }
    push(@comments,"Your notice has been succesfully deposited. You can now\n");
    &wn_patch($dept, $department, $organ, *comments);
    push(@comments,"</BODY></HTML>\n");

}

sub modify_db_entry {

    local($filename, $dept, $department, $organ, *entry, *comments) = @_;


                                   # open the file, and write to it.
    open(FILEOUT, ">$filename")||
		      &f_error("Unable to open $filename for output.\n",__LINE__,__FILE__);
        print FILEOUT @entry;
    close(FILEOUT);

#       Push into array comments to be returned to the user, confirming
#       Deposition of the seminar notice.

    push(@comments,"<HTML><HEAD><TITLE>Notice Succesfully Modified - $department </TITLE>\n");
    push(@comments,"</HEAD> <BODY> <H2 align=center >Notice Succesfully Modified  </H2>\n");
    push(@comments,"<H2>$department\n");
    if($organ ne "Department") {
       push(@comments,": <em>$organ</em> </h2>\n");
    }
    else {
       push(@comments,"</h2>\n");
    }
    push(@comments,"Your notice has been succesfully modified. You can now\n");

    &wn_patch($dept, $department, $organ, *comments);

    push(@comments,"</BODY></HTML>\n");

}
sub cancel_db_entry {

    local($filename, $dept, $department, $organ, *entry, *comments) = @_;


                                   # open the file, and write to it.
    open(FILEOUT, ">$filename")||
		      &f_error("Unable to open $filename for output.\n",__LINE__,__FILE__);
        print FILEOUT @entry;
    close(FILEOUT);

#       Push into array comments to be returned to the user, confirming
#       Deposition of the seminar notice.

    push(@comments,"<HTML><HEAD><TITLE>Notice Succesfully Cancelled - $department </TITLE>\n");
    push(@comments,"</HEAD> <BODY> <H2 align=center >Notice Succesfully Cancelled  </H2>\n");
    push(@comments,"<H2>$department\n");
    if($organ ne "Department") {
       push(@comments,": <em>$organ</em> </h2>\n");
    }
    else {
       push(@comments,"</h2>\n");
    }
    push(@comments,"Your notice has been succesfully cancelled. You can now\n");

    &wn_patch($dept, $department, $organ, *comments);

    push(@comments,"</BODY></HTML>\n");


}


sub wn_patch {

local($dept, $department, $organ, *comments) = @_;

push(@comments,"<ul>\n");
push(@comments,"<li><a href=\"$cgi_dir"."notices_main.pl\">Return</a> to <em>Web</em>Notice home page, or directly...\n");
push(@comments,"<li><b><i>Add</i></b> a notice: <ul>\n");

push(@comments,"<li><a href=\"$cgi_dir"."deposit_form.pl?dept=$dept\">Same</a>");
push(@comments," department (<i>$department</i>)\n");
push(@comments,"<li><a href=\"$cgi_dir"."add_notice.pl\">Different</a> ");
push(@comments,"department.</ul>\n");

push(@comments,"<li><b><i>Modify</i></b> a Notice: <ul> \n");
push(@comments,"<li><a href=\"$cgi_dir"."list_mod_notices.pl?dept=$dept\">Same</a>");
push(@comments," department (<i>$department</i>)\n");
push(@comments,"<li><a href=\"$cgi_dir"."modify_notice.pl\">Different</a> ");
push(@comments,"department.</ul>\n");

push(@comments,"<li><b><i>Cancel</i></b> a Notice: <ul> \n");
push(@comments,"<li><a href=\"$cgi_dir"."list_cancel_notices.pl?dept=$dept\">Same</a>");
push(@comments,"department  (<i>$department</i>)\n");
push(@comments,"<li><a href=\"$cgi_dir"."cancel_notice.pl\">Different</a> ");
push(@comments,"department.</ul><hr width=100% align=left>\n");

push(@comments,"<li><b><i>View</i></b> posted notices: \n");
push(@comments,"<ul>\n");
push(@comments,"<li><b>Same department:</b> \n");

push(@comments,"<a href=\"$cgi_dir"."list_notices.pl?dept=$dept&time_frame=week\">This \n");
push(@comments,"Week</a> | \n");
push(@comments,"<a href=\"$cgi_dir"."list_notices.pl?dept=$dept&time_frame=next_week\">Next \n");
push(@comments,"Week</a> | \n");
push(@comments,"<a href=\"$cgi_dir"."list_notices.pl?dept=$dept&time_frame=month\">This\n");
push(@comments,"Month</a> | \n");
push(@comments,"<a href=\"$cgi_dir"."list_notices.pl?dept=$dept&time_frame=year\">This\n");
push(@comments,"Year</a> (<i>$department</i>)\n");

push(@comments,"<li><a href=\"$cgi_dir"."view_notice.pl\"><b>Select</b></a> ");
push(@comments,"Department(s)<br><br>\n");

if( $organ ne "Department") {
    push(@comments,"<li><b>Same Group:</b> \n");
    push(@comments,"<a href=\"$cgi_dir"."list_notices_bygroup.pl?organ_type=$organ&time_frame=week\">This \n");
    push(@comments,"Week</a> | \n");
    push(@comments,"<a href=\"$cgi_dir"."list_notices_bygroup.pl?organ_type=$organ&time_frame=next_week\">Next \n");
    push(@comments,"Week</a> | \n");
    push(@comments,"<a href=\"$cgi_dir"."list_notices_bygroup.pl?organ_type=$organ&time_frame=month\">This\n");
    push(@comments,"Month</a> | \n");
    push(@comments,"<a href=\"$cgi_dir"."list_notices_bygroup.pl?organ_type=$organ&time_frame=year\">This\n");
    push(@comments,"Year</a> (<i>$organ</i>)<br>\n");
}
push(@comments,"<li><a href=\"$cgi_dir"."view_notice_bygroup.pl\"><b>Select</b></a> Group(s)\n");

push(@comments,"</ul><hr width=100% align=left><br>\n");

push(@comments,"<li><b><a href=\"$cgi_dir"."admin_main.pl\">Notices \n");
push(@comments,"System Administration</a></b> \n");
push(@comments,"(requires a username and password).\n");
push(@comments,"</ul>\n");
push(@comments,"<hr size=3><p align=right> \n");
push(@comments,"<em>......WebNotice System</em> \n");
}

1; 
