# is_authorized_user
#
# Author:  Ian Graham   <ian.graham@utoronto.ca>
# Date:    18 April 1995
#
# PURPOSE
#   This subroutine reads the groups database file and determines if
#   user $depositor is authorized to make changes to group $organ_type.
#   If not, then this routine sends an appropriate error to stdout 
#   and dies.
#
# ----------------------------------------------------------------------
# SUBROUTINE ARGUMENTS
#   $db_b_file      -   database file (full path)
#   $dept           -   department key
#   $organ_type     -   Group name (Program, Institure, etc)
#   $depositor      -   Name of User requesting authorization
#
# SUBROUTINE RETURNED VARIABLES
#   none.  Program returns a value of 1 if succesful, dies if not.
#
# ----------------------------------------------------------------------

sub is_user_authorized  {
   local ($db_b_file, $dept, $organ_type, $depositor) = @_;

   local (@div_keys, %user_id, %listserv, %newsgrps);

   &scan_db_file($db_b_file,$dept, *div_keys, *user_id, *listserv,*newsgrps);

   if( $user_id{$organ_type} !~ $depositor ) {
   
      print "Status: 401 Not Authorized\nWWW-Authenticate: Basic realm=\"$reg_realm\"\nContent-type: text/html\n\n 
<html><head><title>Non-Authorised User</title></head><body> 
<h2> Non-Authorized User </h2> 
<p> I am sorry, but the user <em>$depositor</em> is not 
authorized to deposit seminar notices for the 
<em> $dept</em> $organ_type. Please contact your 
departmental adminstrative officer responsible for submitting 
seminar notices for any corrections that may be required.  
<p> Unfortunately, if you made a mistake selecting the user 
ID at the Username/password pop-up window you will have to exit 
the browser and restart Mosaic or Netscape, as the user ID 
cannot currently be modified from within the program.<hr> </body></html>";

      die "";

   }
   return 1;
}
1;
