#! /usr/local/bin/perl
#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
# 
# Permission to use, copy, modify and distribute without fee any portion 
# of this software and its documentation, for any purpose, is hereby granted 
# without fee, provided that (i) the above copyright notices and this 
# permission notice appear in all copies of the software and related 
# documentation, and (ii) the name of Ian Graham and The University of 
# Toronto may not be used in any advertising or publicity relating to 
# the software without the specific, prior written permission of Ian Graham.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
# 
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
#
# deposit_notice.pl
#
# Ian Graham <ian.graham@utoronto.ca>, Jan 1995
#

require    '../cgi-reg/lib/configure.ph';
require    '../cgi-reg/lib/utils.pl';
require    '../cgi-reg/lib/create_form.pl';
require    'lib/write_db_entry.pl';
require    'lib/construct_entry.pl';
require    'lib/is_user_authorized.pl';

# $DEBUG=1;

if( $DEBUG) {print "Content-type: text/plain\n\n"; }
if( $DEBUG) {print "DEBUG ....\n"; }


$array{"depositor"}   = $ENV{"REMOTE_USER"}; # User ID depositing the Notice
$array{"remote_host"} = $ENV{"REMOTE_HOST"}; # Domain name of depositing machine
$array{"remote_addr"} = $ENV{"REMOTE_ADDR"}; # IP address of depositing machine


&get_group_info($db_file, *dept_list);

$input=<STDIN> ||
     &f_error("Fatal error -- No input data\n", __LINE__, __FILE__);

$input =~ s/\s*$//;                        # chop off trailing whitespace
# chop($input); chop($input);              # chop CR/LF trailing characters 
@fields=split("&",$input);               # split data into separate fields 
foreach $one (@fields) { 
   ($name, $value) = split("=",$one);
   $name =~ s/\+/ /g;                      # convert +'s to spaces
   $name  =~ s/%(..)/pack("c",hex($1))/ge; # convert URL hex codings to Latin-1
   $value =~ s/\+/ /g;                     # convert +'s to spaces
   $value =~ s/%(..)/pack("c",hex($1))/ge; # convert URL hex codings to Latin-1

   $value =~ s/^\s*//;                   # remove leading whitespace chars
   $value =~ s/\s*$//;                   # remove trailing whitespace chars
   $value =~ s/%22/"/g;                  # convert encoded quotes to quotes
   $value =~ s/%3e/>/g;                  # convert encoded > to >

   $array{"$name"} = $value;             # Place content in form field array
}

&is_user_authorized($db_b_file, $array{"dept"}, 
		    $array{"organ_type"}, $array{"depositor"});

#  determine time that the seminar was deposited

foreach (localtime(time))  {
   $loc_time .= ($_." ");
}

if( $DEBUG) { 
    @tmpp = localtime(time);
    print "****** >>>>>> localtime = @tmpp\n"; 
    print "****** >>>>>> loc_time = $loc_time\n"; 
}

$array{"dep_date"}    =  $loc_time;
$array{"new_entry"}   =  "true";
$array{"modified"}    =  "false";

$array{"remote_host"} =  $ENV{"REMOTE_HOST"};
$array{"remote_addr"} =  $ENV{"REMOTE_ADDR"};
$array{"remote_user"} =  $ENV{"REMOTE_USER"};
$time_date_string = $array{"time_date_string"};

if($array{"accept"} eq "yes")  {
  delete $array{"dummy"};
  delete $array{"accept"};
  delete $array{"old_file_name"};
  &construct_entry(*entry, *array);
  $dept       = $array{"dept"};
  $organ      = $array{"organ_type"};
  $department = $dept_list{$dept};
  &write_db_entry($notice_dir, $time_date_string, 
		  $dept,       $department,
		  $organ,      *entry, 
		  *comments, *db_filename);
  &print_page(*comments);

}
else {
  $hidden  =  
  "<INPUT TYPE=\"hidden\" NAME=\"dept\" VALUE=\"$array{\"dept\"}\">\n";
  $hidden .=
  "<INPUT TYPE=\"hidden\" NAME=\"old_file_name\" VALUE=\"$array{\"filename\"}\">\n";
  $department = $dept_list{$array{"dept"}};
  push(@form_err,
   "<hr><p>");
  push(@form_err,
   "<h2>*** Addition Interrupted ***</h2><p>You selected <b><i>no</i></b>");
  push(@form_err,
    "(or failed to select yes) before pressing the <i>Submit</i> button.\n");
  push(@form_err,
    "<p>You can contine to make\n");
  push(@form_err,
    "changes to the posting by editing the form below. Alternatively you\n");
  push(@form_err,
    "can go back to the Home page of the notices system by pressing\n");
  push(@form_err,
    "<a href=\"$rel_cgi_dir"."notices_main.pl\">here</a>.<hr>\n");

  &create_form($deposit_form_tmpl,$department,$hidden,*form_err,*array,*form);
  &print_page(*form);
}

