#! /usr/local/bin/perl
#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
# 
# Permission to use, copy, modify and distribute without fee any portion 
# of this software and its documentation, for any purpose, is hereby granted 
# without fee, provided that (i) the above copyright notices and this 
# permission notice appear in all copies of the software and related 
# documentation, and (ii) the name of Ian Graham and The University of 
# Toronto may not be used in any advertising or publicity relating to 
# the software without the specific, prior written permission of Ian Graham.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
# 
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
#
# delete_notice.pl
#
# Ian Graham <ian.graham@utoronto.ca>, March 1996
#

require    '../cgi-reg/lib/configure.ph';
require    '../cgi-reg/lib/utils.pl';
require    '../cgi-reg/lib/create_form.pl';
require    '../cgi-reg/lib/read_db_file.pl';
require    'lib/write_db_entry.pl';
require    'lib/construct_entry.pl';
require    'lib/is_user_authorized.pl';

@char_arr = ("00", "01", "02", "03", "04", "05", "06", "07", "08", "09");
@mon_str = ("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep",
	    "Oct", "Nov", "Dec"); 

# $DEBUG=1;

if( $DEBUG) {print "Content-type: text/plain\n\n"; }
if( $DEBUG) {print "DEBUG ....\n"; }


$new_depositor   = $ENV{"REMOTE_USER"};    # User ID depositing the Notice
$new_remote_host = $ENV{"REMOTE_HOST"};    # Domain name of depositing machine
$new_remote_addr = $ENV{"REMOTE_ADDR"};    # IP address of depositing machine

&get_group_info($db_file, *dept_list);


$input=<STDIN> || 
     &f_error("Fatal error -- No input data\n", __LINE__, __FILE__);
					   # read FORM data from stdin 
$input =~ s/\s*$//;                        # chop off trailing whitespace
# chop($input); chop($input);                # chop CR/LF trailing characters 
@fields=split("&",$input);                 # split data into separate fields 

foreach $one (@fields) { 
   ($name, $value) = split("=",$one);
   $name =~ s/\+/ /g;                      # convert +'s to spaces
   $name  =~ s/%(..)/pack("c",hex($1))/ge; # convert URL hex codings to Latin-1
   $value =~ s/\+/ /g;                     # convert +'s to spaces
   $value =~ s/%(..)/pack("c",hex($1))/ge; # convert URL hex codings to Latin-1

   $value =~ s/^\s*//;                     # remove leading whitespace chars
   $value =~ s/\s*$//;                     # remove trailing whitespace chars

   $input{"$name"} = $value;               # Place content in form field array
}

push(@filenames, $input{"old_file_name"});
$old_file = $notice_dir."/".$input{"old_file_name"};
&read_db_file($old_file, *old_array);

&is_user_authorized($db_b_file, $old_array{"dept"}, 
	$old_array{"organ_type"}, $new_depositor);

#  determine time that the seminar was deposited

foreach (localtime(time))  {
   $loc_time .= ($_." ");
}

if( $DEBUG) { 
    @tmpp = localtime(time);
    print "****** >>>>>> localtime = @tmpp\n"; 
    print "****** >>>>>> loc_time = $loc_time\n"; 
}

if($input{"accept"} eq "yes")  {

# $DEBUG=1;
if($DEBUG) {
  print "Content-type text/plain\n\n";
  print "Doing file  $old_file\n";
}
  while(defined($old_array{"link_from"}) )  {
      if($DEBUG){ print "Doing file ($old_array{\"link_from\"}\n"; }
      push(@filenames, $old_array{"link_from"});   
      $old_file = $notice_dir."/".$old_array{"link_from"};
      %old_array = ();
      &read_db_file($old_file, *old_array);
  }

  foreach $file (@filenames) {
      if($DEBUG){ print "Doing file $file\n"; }
      $tmp   = $notice_dir."/".$file;
      $year  = $file;
      $year  =~ s/(....).*/$1/;
      $month = $file;
      $month =~ s/....(..).*/$1/;
      $month = $mon_str[$month];
      $path  = $notice_dir."/Delete";
      if( !(-d  $path) ) {
         if( !mkdir($path,0755) ) {
              die "Unable to Create Directory in __FILE__ at line __LINE__\n";
         }
      }
      $path  = $path."/".$year;
      if( !(-d  $path) ) {
         if( !mkdir($path,0755) ) {
              die "Unable to Create Directory in __FILE__ at line __LINE__\n";
         }
      }
      $path = $path."/".$month;
      if( !(-d $path) ) {
          if( !mkdir($path,0755) ) {
              die "Unable to Create Directory in __FILE__ at line __LINE__\n";
          }
      }
     $tmp2 = $path."/".$file;
     system("/bin/mv $tmp $tmp2");
  }

  push(@comments,
    "<HTML><HEAD><TITLE>Deletion Completed</TITLE></HEAD>\n");
  push(@comments, "<h1 align=center>Deletion Completed</h1>");
  push(@comments, "<p>The notice posting has been deleted, as per your request.\n");
  push(@comments, "<hr><p align=right><em>Web</em>Notice\n</body>\n</html>");
  &print_page(*comments);
}
else {
  push(@comments,
    "<HTML><HEAD><TITLE>Deletion Interrupted</TITLE></HEAD>\n");
  push(@comments,
    "<BODY><H1 align=center><em>UofT</em>Notices</H1><hr>\n");
  push(@comments,
    "<BODY><H2>Deletion of Notice Interrupted</H2>\n");
  push(@comments,
    "<P>You selected <b><em>no</em></b> or your neglected \n");
  push(@comments,
    " to select <b><em>yes</em></b> before pressing the button.\n");
  push(@comments,
    "Press your web browser's <em>back</em> button to return to the \n");
  push(@comments,
    "selection page.\n Press <a href=\"$rel_cgi_dir"."notices_main.pl\">here</A> to return to the\n ");
  push(@comments,
    "home page of the <em>Web</em>Notice system.\n");
  push(@comments,
    "<HR></BODY></HTML>");
  &print_page(*comments);
}

   

