#! /usr/local/bin/perl

#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
# 
# Permission to use, copy, modify and distribute without fee any portion 
# of this software and its documentation, for any purpose, is hereby granted 
# without fee, provided that (i) the above copyright notices and this 
# permission notice appear in all copies of the software and related 
# documentation, and (ii) the name of Ian Graham and The University of 
# Toronto may not be used in any advertising or publicity relating to 
# the software without the specific, prior written permission of Ian Graham.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
# 
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
#
# cancel_notice.pl
#
# Ian Graham <ian.graham@utoronto.ca>, Jan 1995
#

require    '../cgi-reg/lib/configure.ph';
require    '../cgi-reg/lib/utils.pl';
require    '../cgi-reg/lib/create_form.pl';
require    '../cgi-reg/lib/read_db_file.pl';
require    'lib/write_db_entry.pl';
require    'lib/construct_entry.pl';
require    'lib/is_user_authorized.pl';

#$DEBUG=1;

if( $DEBUG) {print "Content-type: text/plain\n\n"; }
if( $DEBUG) {print "DEBUG ....\n"; }


$new_depositor   = $ENV{"REMOTE_USER"};    # User ID depositing the Notice
$new_remote_host = $ENV{"REMOTE_HOST"};    # Domain name of depositing machine
$new_remote_addr = $ENV{"REMOTE_ADDR"};    # IP address of depositing machine

&get_group_info($db_file, *dept_list);


$input=<STDIN> || 
     &f_error("Fatal error -- No input data\n", __LINE__, __FILE__);
					   # read FORM data from stdin 
$input =~ s/\s*$//;                        # chop off trailing whitespace
# chop($input); chop($input);                # chop CR/LF trailing characters 
@fields=split("&",$input);                 # split data into separate fields 

foreach $one (@fields) { 
   ($name, $value) = split("=",$one);
   $name =~ s/\+/ /g;                      # convert +'s to spaces
   $name  =~ s/%(..)/pack("c",hex($1))/ge; # convert URL hex codings to Latin-1
   $value =~ s/\+/ /g;                     # convert +'s to spaces
   $value =~ s/%(..)/pack("c",hex($1))/ge; # convert URL hex codings to Latin-1

   $value =~ s/^\s*//;                     # remove leading whitespace chars
   $value =~ s/\s*$//;                     # remove trailing whitespace chars

   $input{"$name"} = $value;               # Place content in form field array
}

$old_file = $notice_dir."/".$input{"old_file_name"};
&read_db_file($old_file, *old_array);

&is_user_authorized($db_b_file, $old_array{"dept"}, 
	$old_array{"organ_type"}, $new_depositor);

#  determine time that the seminar was deposited

foreach (localtime(time))  {
   $loc_time .= ($_." ");
}

if( $DEBUG) { 
    @tmpp = localtime(time);
    print "****** >>>>>> localtime = @tmpp\n"; 
    print "****** >>>>>> loc_time = $loc_time\n"; 
}

if($input{"accept"} eq "yes")  {

  $new_dep_date             =  $loc_time;

  $old_array{"depositor"}   = $old_array{"depositor"}." : ".$new_depositor;
  $old_array{"remote_host"} = $old_array{"remote_host"}." : ".$new_remote_host;
  $old_array{"remote_addr"} = $old_array{"remote_addr"}." : ".$new_remote_addr;
  $old_array{"locat"} = "<B> *** CANCELLED *** </B>";
#  $old_array{"other_info"} =  "<p align=\"center\"> <B> *** Cancelled *** </B><p>\n".$old_array{"other_info"}."<p align=\"center\"><B><EM>\n".$input{"cancelled"}."</em></b>";
  $old_array{"other_info"} =  " <i><b> *** Cancelled -- \n</b>".$input{"cancelled"}."</i>";
  
  delete $old_array{"dummy"};
  delete $old_array{"accept"};
  
  $old_array{"modified"}  = "delete";
  $old_array{"new_entry"} = "false";
  if($DEBUG) {print "Construct new entry\n"; }
  &construct_entry(*entry, *old_array);
  $dept       = $old_array{"dept"};
  $organ      = $old_array{"organ_type"};
  $department = $dept_list{$dept};
  if($DEBUG) {print "New Entry Constructed\n"; }
  &cancel_db_entry($old_file, $dept, $department, 
		   $organ, *entry, 
		   *comments);
  if($DEBUG) {print "New modifications deposited\n"; }
  
  &print_page(*comments);
}
else {
  push(@comments,
    "<HTML><HEAD><TITLE>Cancellation Interrupted</TITLE></HEAD>\n");
  push(@comments,
    "<BODY><H1 align=center><em>UofT</em>Notices</H1><hr>\n");
  push(@comments,
    "<BODY><H2>Cancellation of Notice Interrupted</H2>\n");
  push(@comments,
    "<P>You selected <b><em>no</em></b> or your neglected \n");
  push(@comments,
    " to select <b><em>yes</em></b> before pressing the button.\n");
  push(@comments,
    "Press your web browser's <em>back</em> button to return to the \n");
  push(@comments,
    "selection page.\n Press <a href=\"$rel_cgi_dir"."notices_main.pl\">here</A> to return to the\n ");
  push(@comments,
    "home page of the Notices posting system.\n");
  push(@comments,
    "<HR></BODY></HTML>");
  &print_page(*comments);
}

   

