#! /usr/local/bin/perl
#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
#
# Permission to use, copy, modify and distribute without fee any portion
# of this software and its documentation, for any purpose, is hereby granted
# without fee, provided that (i) the above copyright notices and this
# permission notice appear in all copies of the software and related
# documentation, and (ii) the name of Ian Graham and The University of
# Toronto may not be used in any advertising or publicity relating to
# the software without the specific, prior written permission of Ian Graham.
#
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
#
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
# 
# process_modify.pl 
# 
# Revision:  1.0
# Date:      8 January 1995
# Author:    Ian Graham <ian.graham@utoronto.ca>
#

# $DEBUG=1;

if( $DEBUG) {print "Content-type: text/plain\n\n"; }
if( $DEBUG) {print "DEBUG ....\n"; }


require   'lib/configure.ph';
require   'lib/create_notice.pl';
require   'lib/create_form.pl';
require   'lib/massage_time_and_date.pl';
require   'lib/utils.pl';


&get_group_info($db_file, *dept_list);

if ($DEBUG) { print "read and processed database \n"; }

$input=<STDIN>;                          # read FORM data from stdin 
$input =~ s/\s*$//;                        # chop off trailing whitespace
# chop($input); chop($input);              # chop CR/LF trailing characters 
@fields=split("&",$input);               # split data into separate fields

if ($DEBUG) { print "read stdin fields are:  @fields\n"; }

foreach $one (@fields) {

   ($name, $value) = split("=",$one);
   $name  =~ s/\+/ /g;                     # convert +'s to spaces
   $name  =~ s/%(..)/pack("c",hex($1))/ge; # convert URL hex codings to Latin-1
   $value =~ s/\+/ /g;                     # convert +'s to spaces
   $value =~ s/%(..)/pack("c",hex($1))/ge; # convert URL hex codings to Latin-1
   $value =~ s/^\s*//;                   # remove leading whitespace chars
   $value =~ s/\s*$//;                   # remove trailing whitespace chars
   $value =~ s/%22/"/g;                  # convert encoded quotes to quotes
   $value =~ s/%3e/>/g;                  # convert encoded > to >

# If this is *not* a textarea input element, encode all dangerous
# characters by they entity refs:

   if(($name !~ /abstract/) && ($name !~ /other/) && ($name !~ /affil/))  {
        $value =~ s/</&lt;/g;            # chars (< > ") to entity references.
        $value =~ s/>/&gt;/g;
        $value =~ s/\"/&quot;/g;
   }


   $array{"$name"} = $value;             # Place name/value pairs in 
					 # associative array "array".
}

if ($DEBUG) { print "Unpacked data into associative array....\
Array{time} = $array{\"time\"}, Date = $array{\"date\"}\n"; }

&massage_time_and_date(*num_date, *array, *pr_error);     
					 # Process time and date - check
					 # for valid entries and convert
					 # to preferred format. 

                                         # Place dept/name pair in hidden
					 # element for possible return with
					 # a returned (for correction) form.
if ($DEBUG) { print "Massaged time and date \n"; }
$sh_hidden=
   "<INPUT TYPE=\"hidden\" NAME=\"dept\" VALUE=\"$array{\"dept\"}\">\n";
$sh_hidden .=
   "<INPUT TYPE=\"hidden\" NAME=\"old_file_name\" VALUE=\"$array{\"old_file_name\"}\">\n";
   
					 # Place proper name of department
					 # in variable $department
$department = $dept_list{$array{"dept"}};

                                         # Place all name/value pairs in
                                         # hidden element array for inclusion
@fields = keys(%array);                  # with formatted seminar notice.
$n_input=0;
foreach (@fields) {
   $tmp = $array{$_};
   $tmp =~ s/>/%3e/g;
   $tmp =~ s/"/%22/g;
   $hidden[$n_input] = "<INPUT TYPE=\"hidden\" NAME=\"$_\" VALUE=\"$tmp\">\n";
   $n_input++;
}

if ($DEBUG) { print "testing arrays for contents....\n"; }

					 # Check form fields -- time and date
					 # were done in massage_time_and_date().
					 # This checks for fields that are 
					 # empty, and should not be so.  Errors
					 # information is pushed into the array
					 # @pr_error.
if( $array{"dept"} !~ /\S+/) {
  push(@pr_error, "You did not choose a Department or Faculty.");
}
if( $array{"locat"} !~ /\S+/) {
  push(@pr_error, "You did not give a location for the event (T.B.A. is fine).");
}
if( $array{"speak"} !~ /\S+/) {
  push(@pr_error, "You did not give the name of the speaker (T.B.A is fine).");
}
if( $array{"affil"} !~ /\S+/) {
  push(@pr_error, "You did not give the speakers affiliation or home instituition (T.B.A. is fine).");
}
if( $array{"t_title"} !~ /\S+/) {
    $array{"t_title"} = "Title not available\n";
#   push(@pr_error, "You did not give the title of the talk (T.B.A. is fine).");
}
if( $array{"t_abstract"} !~ /\S+/) {
    $array{"t_abstract"} = "Abstract not available.\n";
#  push(@pr_error, "You did not give an abstract for the talk (T.B.A. is fine).");
}

                                     # If no errors generate formatted seminar 
                                     # notice. If errors report them, return 
				     # the form, for correction, to the client. 
if( defined(@pr_error) ) {
   if ($DEBUG) {   print "PR_ERROR IS DEFINED --------\n"; }
   if ($DEBUG) {   print "PR_EROR = @pr_error\n"; }
   push(@form_err, "<HR>\n");
   push(@form_err, "<H1> Errors on Form Fields </H1>\n");
   push(@form_err, "We have detected some problems with the input fields in");
   push(@form_err, "your FORM.\n These errors were (approximately):\n <UL> ");
   push(@form_err, "<LI> $tmp\n") while defined($tmp = pop(@pr_error));
   push(@form_err, "</UL> <P> Please correct the FORM (reproduced below) ");
   push(@form_err, " and resubmit. <HR> \n");
   &create_form($modify_form_tmpl, $department, $sh_hidden, 
		*form_err, *array, *form);
   &print_page(*form);
}
else {
   if ($DEBUG) {  print "PR_ERROR IS ***NOT*** DEFINED --------\n"; }
   &create_notice($check_modify_notice_tmpl, *dept_list, *hidden, 
		  *array, *page);
   &print_page(*page);
}
