#! /usr/local/bin/perl
#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
# 
# Permission to use, copy, modify and distribute without fee any portion 
# of this software and its documentation, for any purpose, is hereby granted 
# without fee, provided that (i) the above copyright notices and this 
# permission notice appear in all copies of the software and related 
# documentation, and (ii) the name of Ian Graham and The University of 
# Toronto may not be used in any advertising or publicity relating to 
# the software without the specific, prior written permission of Ian Graham.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
# 
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
# modify.pl
#
# Revision:  1.0
# Date:      8 January 1995
# Author:    Ian Graham <ian.graham@utoronto.ca>
#
# This perl program is accessed from the Departmental selection page 
# generated by the program "add_notice.pl".  This program generates a
# department-specific seminar information input form. 

# Debug Use variable $DEBUG to set debug mode.

#$DEBUG = 1;

require 'lib/configure.ph';
require 'lib/utils.pl';
require 'lib/create_form.pl';
require 'lib/read_db_file.pl';

if ($DEBUG) {print "Content-type: text/plain\n\n"; } 
if ($DEBUG) {print "DEBUG MODE --\n"; }            

if (defined( $ENV{"QUERY_STRING"} )) {
    $filename=$ENV{"QUERY_STRING"};
}
else {
    &no_file_specified();
}

$filename =~ s/\+/ /g;                     # convert +'s to spaces
$filename =~ s/%(..)/pack("c",hex($1))/ge; # convert URL hex codings to Latin-1


#
# Open database file to get list of proper names for the department.
#

&get_group_info($db_file, *dept_name);

if($DEBUG) { print " Filename = $filename\n"; }

$full_filename   = $notice_dir."/".$filename;

if($DEBUG) { print " Filename = $filename\n"; }

&read_db_file($full_filename, *array);

$department = $dept_name{$array{"dept"}};

$sh_hidden  =  "<INPUT TYPE=\"hidden\" NAME=\"dept\" VALUE=\"$array{\"dept\"}\">\n";
$sh_hidden .= 
	"<INPUT TYPE=\"hidden\" NAME=\"old_file_name\" VALUE=\"$filename\">\n";

if($DEBUG) { print "department = $department,\n     $hidden = $sh_hidden\n";}


&create_form($modify_form_tmpl, $department, $sh_hidden, 
	     *form_err, *array, *form );

&print_page(*form);


# End of Main Program ----------------------------------------------------


