#! /usr/local/bin/perl

#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
#
# Permission to use, copy, modify and distribute without fee any portion
# of this software and its documentation, for any purpose, is hereby granted
# without fee, provided that (i) the above copyright notices and this
# permission notice appear in all copies of the software and related
# documentation, and (ii) the name of Ian Graham and The University of
# Toronto may not be used in any advertising or publicity relating to
# the software without the specific, prior written permission of Ian Graham.
#
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
#
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
# list_notices_bygroup_p.pl
#
# Revision:  1.0
# Date:      8 January 1995
# Author:    Ian Graham <ian.graham@utoronto.ca>


# Use DeBUG to set debug mode:

#$DEBUG = 1;   # -------- Debug flag  


require 'lib/configure.ph';
require 'timelocal.pl';
require 'lib/utils.pl';
require 'lib/extract_short_entry_print.pl';
require 'lib/read_db_file.pl';
require 'lib/time_interval.pl';

if ($DEBUG) {print "Content-type: text/plain\n\n"; }   
if ($DEBUG) {print "DEBUG MODE --\n\n"; }               

$input=$ENV{"QUERY_STRING"};             # input comes from query string;

if( $input !~ /organ_type=/) {           # if input string has no 'organ_type=' 
    &no_dept_specified;                  # string then the user forgot 
					 # to specify a Department.
}

$all_organs = 0;
$num_grps   = 0;                         # count number of groups in this 
                                         # short list. The behavior is
		                         # for values of 0, 1, or >1.
   
@tmp=split("&",$input);                  # split data into separate fields.
foreach (@tmp) {
   s/\+/ /g;                             # convert +'s to spaces
   if(/organ_type=/) {
       if( /organ_type=all_organs/) {
	  $all_organs = 1;
	  $num_grps   = 2;
       }
       else {
          s/organ_type=//; 
          s/%(..)/pack("c",hex($1))/ge;  # convert URL hex codings to Latin-1
          $organ_arr{"$_"} = "$_";       
	  if($DEBUG) { print " **** THIS KEY = $_ \n"; }
	  $num_grps += 1;
       }
   }
   elsif(/time_frame=/) {
       s/time_frame=//;
       s/%(..)/pack("c",hex($1))/ge; 
       $time_frame = $_;
   }
   else {
       &f_error("Invalid Argument in input query string -- $_\n", __FILE__, __LINE__);
   }
}


if( $all_organs ) { 
   &get_group_info($db_file, *dept_list);
   foreach $dept (keys(%dept_list) ) {
      @division_keys=();
      &scan_db_file($db_b_file, $dept,
                    *division_keys, *user_id, *listserv, *newsgrps);
      foreach (@division_keys) {
         if( !/Department/ ) { $organ_arr{$_}  = " "}
      }
   }
}
                                         # Access seminar notices database
					 # directory and get a list of the 
					 # files.

if($DEBUG) { print "KEYS KEYS KEYS:"; 
	     foreach (keys(%organ_arr)) { print "$_ -*- "; }
           }

if( !opendir(DIR, $notice_dir)) {
	 &f_error("Unable to open notices directory $notice_dir\n"); }
   @tmp = readdir(DIR);
   foreach (@tmp) { 
       push(@filenames,$_) if -T $notice_dir."/".$_;
   }
close(DIR);

@filenames = sort(@filenames);     # Sort filename list in ascending order
				   # recall that the filename contains 
				   # the date...

                                   # Get current date

if($time_frame eq "week") {
     $start  = 1;
     $length = 6;
}
elsif($time_frame eq "next_week") {
     $start  = 7;
     $length = 6;
}
elsif($time_frame eq "month") {
     $start  = 1;
     $length = 31;
}
elsif($time_frame eq "year") {
     $start  =  1;
     $length = -1;
}

if($DEBUG) { print "\n  Start of time interval= $start\n"; }
if($DEBUG) { print "  Length of time interval= $length\n"; }

if(!(&time_interval($start,       $length, 
		    *fname_start, *date_start,
                    *fname_stop,  *date_stop, *error)) ) 
    {
       &f_error($error, __FILE__, __LINE__);
    }


if($DEBUG) { print "\n Start FILENAME = $fname_start\n"; }
if($DEBUG) { print " Stop  FILENAME = $fname_stop\n\n"; }

push(@seminars, "<HTML><HEAD><TITLE>Selected Listings: by Group</TITLE>\n");
push(@seminars,"<\HEAD><BODY>\n");
if( $num_grps == 1) {
    @foo = keys(%organ_arr);
    if($DEBUG) { print " --- FOO = @foo\n"; }
    if($DEBUG) { print " --- FOO = @foo\n"; }
    if($DEBUG) { print " --- FOO = @foo\n"; }
    $tmp = $foo[0];
    push(@seminars,
	"<H2 align=\"center\"> <em>Web</em>Notice Postings for $tmp </H2>\n");
    push(@seminars,
	"<H3 align=\"center\">$date_start through $date_stop </H3>\n");
    push(@seminars, "<hr><DL>\n");
}
else {
    push(@seminars,
     "<H2 align=\"center\"><em>Web</em>Notices Group Postings:\n");
    push(@seminars,"$date_start through $date_stop </H2>\n");


    if( $all_organs ) {
        push(@seminars, "<H3>Postings for all Groups:</H3> <HR>\n");
	push(@seminars, "<HR><DL>\n");
    }
    else {
        push(@seminars, "<H3>Postings for Groups:</H3> <UL>\n");
        foreach( keys(%organ_arr) ) {
             push(@seminars, "<LI> $_ \n");
        }
        push(@seminars, "</UL><hr><DL>\n");
    }
}

# if ($DEBUG) {print "pushed headers - they are @seminars";}

foreach $file (@filenames) {
  if ($DEBUG) { print " ---- Filtered files -- $file\n"; }
  if( ($file gt $fname_start) && ($file lt $fname_stop) )  {
      %array = ();
      $entry = ();
      $full_filename = $notice_dir."/".$file;
      if ($DEBUG) { print " ----  **Extracting file -- $full_filename\n"; }
      &read_db_file($full_filename, *array);
      if ($DEBUG) { print " ---- ** Extracted file -- $full_filename\n"; }
      if( defined($organ_arr{$array{"organ_type"}}) ) {
        &extract_short_entry_bygroup_print($num_grps, *organ_arr, 
					   *array,    *entry);
      }
      push(@seminars, $entry);
  }
}

push(@seminars, "</DL><hr><p align=right><em> ...... WebNotice</em>\n");
push(@seminars, "</BODY></HTML>\n");

print "Content-type: text/html\n\n";
print "@seminars";

