#! /usr/local/bin/perl


#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
#
# Permission to use, copy, modify and distribute without fee any portion
# of this software and its documentation, for any purpose, is hereby granted
# without fee, provided that (i) the above copyright notices and this
# permission notice appear in all copies of the software and related
# documentation, and (ii) the name of Ian Graham and The University of
# Toronto may not be used in any advertising or publicity relating to
# the software without the specific, prior written permission of Ian Graham.
#
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
#
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
# list_notices.pl
#
# Revision:  1.0
# Date:      8 January 1995
# Author:    Ian Graham <ian.graham@utoronto.ca>


# Use DeBUG to set debug mode:

#$DEBUG = 1;   # -------- Debug flag  


require 'lib/configure.ph';
require 'timelocal.pl';
require 'lib/utils.pl';
require 'lib/extract_short_entry.pl';
require 'lib/time_interval.pl';

if ($DEBUG) {print "Content-type: text/plain\n\n"; }   
if ($DEBUG) {print "DEBUG MODE --\n\n"; }               


$input=$ENV{"QUERY_STRING"};             # input comes from query string;

if( $input !~ /dept=/) {                 # if input string has no 'dept=' 
    &no_dept_specified;                  # string then the user forgot 
					 # to specify a Department.
}
   
@tmp=split("&",$input);                  # split data into separate fields.
foreach (@tmp) {
   s/\+/ /g;                             # convert +'s to spaces
   if(/dept=/) {
       if( /dept=all_depts/) {
	  $all_depts = 1;
       }
       else {
          s/dept=//; 
          s/%(..)/pack("c",hex($1))/ge;  # convert URL hex codings to Latin-1
          $dept_arr{"$_"} = "";       
       }
   }
   elsif(/time_frame=/) {
       s/time_frame=//;
       s/%(..)/pack("c",hex($1))/ge; 
       $time_frame = $_;
   }
   else {
       &f_error("Invalid Argument in input query string -- $_\n", __FILE__, __LINE__);
   }
}


if( !( -e $db_file) ) {
   &f_error("File $db_file does not exist.\n", __LINE__, __FILE__);
}
if( !( -r $db_file) ) {
   &f_error("File $db_file exists but is not readable.\n", __LINE__, __FILE__);
}

open(DBASE, $db_file) ||
		  &f_error("Unable to open database.\n",__LINE__,__FILE__);

while(<DBASE>) {
   s/\s/ /g;                    # convert tabs to single space
   s/ +/ /g;                    # remove multiple space characters
   s/ *: */:/g;                 # remove leading/trailing blanks before :
   s/^ +//g;                    # remove leading blanks
   if( !(/^ *#/)  && /\S/ ) {   # skip comment lines

      @db_entry=split(":",$_);
      if( defined($dept_arr{$db_entry[0]}) ||  defined ($all_depts) ) {
	    $dept_arr{$db_entry[0]} = $db_entry[1];
      }
   }
}
close(DBASE);

                                         # Access seminar notices database
					 # directory and get a list of the 
					 # files.

if( !opendir(DIR, $notice_dir)) {
	 &f_error("Unable to open notices directory $notice_dir\n"); }
   @tmp = readdir(DIR);
   foreach (@tmp) { 
       push(@filenames,$_) if -T $notice_dir."/".$_;
   }
close(DIR);

@filenames = sort(@filenames);          # Sort filename list in ascending order
					# recall that the filename contains 
					# the date...

                                        # Get current date



if($time_frame eq "week") {
     $start  = 1;
     $length = 6;
}
elsif($time_frame eq "next_week") {
     $start  = 7;
     $length = 6;
}
elsif($time_frame eq "month") {
     $start  = 1;
     $length = 31;
}
elsif($time_frame eq "year") {
     $start  =  1;
     $length = -1;
}

if($DEBUG) { print "\n  Start of time interval= $start\n"; }
if($DEBUG) { print "  Length of time interval= $length\n"; }

if(!(&time_interval($start,       $length, 
		    *fname_start, *date_start,
                    *fname_stop,  *date_stop, *error)) ) 
    {
       &f_error($error, __FILE__, __LINE__);
    }

if($DEBUG) { print "\n Start FILENAME = $fname_start\n"; }
if($DEBUG) { print " Stop  FILENAME = $fname_stop\n\n"; }

# push(@seminars, "<HTML><HEAD><TITLE> Listings for $date_start to $date_stop</TITLE>\n");
push(@seminars, "<HTML><HEAD><TITLE>Selected Listings: by Department</TITLE>\n");
push(@seminars,"<\HEAD><BODY>\n");
push(@seminars,"<H2 align=\"center\"><em>Web</em>Notice Brief Listings - by Department<br>\n");
push(@seminars,"$date_start through $date_stop </H2>\n");
push(@seminars,"<H3 align=\"center\">Select an entry for additional information</H3>\n");
$tmp = $cgi_dir."list_notices_p.pl?".$input;
push(@seminars,
     "<H4 align=\"center\">Select <A HREF=\"$tmp\"><EM>here</EM></A> for a print-format list</h4>");

push(@seminars,"<center> <TABLE align=right border > <TR> \n");
push(@seminars,"<TD align=left> <IMG SRC=\"".$rel_doc_dir."new-yellow.gif\" ALT=\"[New!]\"> <em>Notice less than 2 days old</em>\n");
push(@seminars,"<TR> <TD align=left> <IMG SRC=\"".$rel_doc_dir."new-green.gif\" ALT=\"[New!]\">  <em> Notice 2 to 7 days old</em>\n");
push(@seminars,"</TR></TABLE></center>\n");

if( defined($all_depts) ) {
    push(@seminars, "<H3>Postings for all Departments:</H3> \n");
}
else {
    push(@seminars, "<H3>Postings for Departments:</H3> <UL>\n");
    foreach( keys(%dept_arr) ) {
         push(@seminars, "<LI> $dept_arr{$_} \n");
    }
}
push(@seminars, "</UL><hr><DL>\n");

# if ($DEBUG) {print "pushed headers - they are @seminars";}

foreach $file (@filenames) {
  if ($DEBUG) { print " ---- Filtered files -- $file\n"; }
  if( ($file gt $fname_start) && ($file lt $fname_stop) )  {
      if ($DEBUG) { print " ---- Extracting file -- $file\n"; }
      $url = $cgi_dir."list_full.pl?".$file;
      &extract_short_entry($file, $url, *dept_arr, *entry);
      push(@seminars, $entry);
  }
}

push(@seminars, "</DL><hr><p align=right><em> ...... WebNotice</em>\n");
push(@seminars, "</BODY></HTML>\n");

print "Content-type: text/html\n\n";
print "@seminars";

