#! /usr/local/bin/perl
#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
#
# Permission to use, copy, modify and distribute without fee any portion
# of this software and its documentation, for any purpose, is hereby granted
# without fee, provided that (i) the above copyright notices and this
# permission notice appear in all copies of the software and related
# documentation, and (ii) the name of Ian Graham and The University of
# Toronto may not be used in any advertising or publicity relating to
# the software without the specific, prior written permission of Ian Graham.
#
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
#
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
# list_newsgroups.pl
# 
# Revision:  1.0
# Date:      8 January 1995
# Author:    Ian Graham <ian.graham@utoronto.ca>
#
# This program reads the list of allowed newsgroups and prints out an
# HTML listing.

#$DEBUG = 1;

require './lib/configure.ph';
require './lib/utils.pl';
require '../admin/lib/config_adm.ph';

if ($DEBUG) {print "Content-type: text/plain\n\n"; }
if ($DEBUG) {print "DEBUG MODE --\n"; }
if ($DEBUG) {print "news_file = $news_file\n"; }

# Pretty boring, but useful.
print "Content-type: text/html\n\n"; 

open(FILE, $news_file) ||
    &f_error("Unable to open newsgroup file: $news_file\n",__LINE__,__FILE__);

@array=<FILE>;
close(FILE);
if ($DEBUG) {print "array = @array--\n"; }

foreach(@array) {
   s/#.*//;
   s/\s*//g;
   if( /\w/ ) {
      $arr{$_} = $_;
   }
}

@list = keys(%arr);

if ($DEBUG) {print "list = @list--\n"; }

if(defined(@array)) {

print STDOUT <<EOF;
<HEAD>
<TITLE> List of All Allowed Newsgroups </TITLE>
</HEAD>
<BODY>
<H1 align=center> List of Allowed Newsgroups </H1>
<P> 
    The following is a list of all the newsgroups currently 
    supported by the Notices Distribution System. Details about
    the intended audiences and content of these groups is found in a
    <A href="${rel_doc_dir}news_info.html"><b>supporting document</b></a>.
    If you want to add another group to this list, you must contact 
    the WebNotices system administrator, <b>$notice_manager_name</b>, 
    at:
</P>
<P align=center> <b>E-mail:</b> <a href=\"mailto:$email_address\">$email_address</a> <br>
      <b>Tel:</b> $phone_number
</p>
</blockquote>
<HR SIZE=2>
<h2>Newsgroups:</h2>
<UL PLAIN COMPACT>

EOF

  foreach(@list) {
     print "<LI>$_";
  }

print "</UL> \n";
print "</BODY> \n";
print "</HTML> \n";
}


