#! /usr/local/bin/perl

#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
# 
# Permission to use, copy, modify and distribute without fee any portion 
# of this software and its documentation, for any purpose, is hereby granted 
# without fee, provided that (i) the above copyright notices and this 
# permission notice appear in all copies of the software and related 
# documentation, and (ii) the name of Ian Graham and The University of 
# Toronto may not be used in any advertising or publicity relating to 
# the software without the specific, prior written permission of Ian Graham.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
# 
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
# list_delete_notices.pl
#
# Revision:  1.0
# Date:      8 January 1995
# Author:    Ian Graham <ian.graham@utoronto.ca>

# Use DEBUG to set debug mode:

#$DEBUG = 1;   # -------- Debug flag  

require 'lib/configure.ph';
require 'timelocal.pl';
require 'lib/utils.pl';
require 'lib/extract_short_entry.pl';

@char_arr = ("00", "01", "02", "03", "04", "05", "06", "07", "08", "09");
@weekday  = ("Sunday",  "Monday",  "Tuesday",  "Wednesday",  "Thursday", 
             "Friday",  "Saturday");
@month    = ("Jan", "Feb", "Mar", "Apr", "May", "Jun",
             "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" );


if ($DEBUG) {print "Content-type: text/plain\n\n"; }   
if ($DEBUG) {print "DEBUG MODE --\n\n"; }               


$input=$ENV{"QUERY_STRING"};             # input comes from query string;

if( $input !~ /dept=/) {                 # if input string has no 'dept=' 
    &no_dept_specified;                  # string then the user forgot 
}
   
$input =~ s/dept=//; 
$input =~ s/%(..)/pack("c",hex($1))/ge;  # convert URL hex codings to Latin-1

# OK.  Input string contains department key.

if( !( -e $db_file) ) {
   &f_error("File $db_file does not exist.\n", __LINE__, __FILE__);
}
if( !( -r $db_file) ) {
   &f_error("File $db_file exists but is not readable.\n", __LINE__, __FILE__);
}

open(DBASE, $db_file) ||
		  &f_error("Unable to open database.\n",__LINE__,__FILE__);

while(<DBASE>) {
   s/\s/ /g;                    # convert tabs to single space
   s/ +/ /g;                    # remove multiple space characters
   s/ *: */:/g;                 # remove leading/trailing blanks before :
   s/^ +//g;                    # remove leading blanks
   if( !(/^ *#/)  && /\S/ ) {   # skip comment lines
      @db_entry=split(":",$_);
      if($db_entry[0] eq $input ) {
          $dept_arr{$input} = $db_entry[1];   # only archive selected dept
      }
   }
}
close(DBASE);

$department = $dept_arr{$input};         # Get proper name of department


                                         # Access seminar notices database
					 # directory and get a list of the 
					 # files.

if( !opendir(DIR, $notice_dir)) {
	 &f_error("Unable to open notices directory $notice_dir\n"); }
   @tmp = readdir(DIR);
   foreach (@tmp) { 
       push(@filenames,$_) if -T $notice_dir."/".$_;
   }
close(DIR);

@filenames = sort(@filenames);          # Sort filename list in ascending order
					# recall that the filename contains 
					# the date...

                                        # Get current date


push(@seminars, 
   "<HTML><HEAD><TITLE> Cancel a Notice: Listings for $department </TITLE>\n");
push(@seminars,"<\HEAD><BODY>\n");
push(@seminars,
   "<H2 align=\"center\"><em>Web</em>Notice: Cancel a Notice <br> Listings Summary for $department.</h2>\n");
push(@seminars,"Click on the notice you wish to delete. Recall that deleting a notice removes it permanently from the <em>Web</em>Notice database.<hr> <DL>\n");


# if ($DEBUG) {print "pushed headers - they are @seminars";}

$success = 0;

foreach $file (@filenames) {
  if ($DEBUG) { print " ---- Filtered files -- $file\n"; }
  $url = $cgi_dir."delete.pl?".$file;
  if( &extract_short_entry_nomods($file, $url, *dept_arr, *entry) ) {
     $success++;
     push(@seminars, $entry);
  }
}

if ($success == 0) {
  push(@seminars, 
     "<DT>&#160;<DD>No listings are currently registered under this name.\n
If you wish to select another department press your browser's \n<em>
Back</em> button to return to the departmental selection menu.\n");
}

push(@seminars, "</DL><HR></BODY></HTML>\n");

print "Content-type: text/html\n\n";
print "@seminars";

