sub print_page {        # print the passed array to standard output 
                        # this is useful for printing a generated page
			# of HTML to the client.

   local (*tmp) = @_;
   print "Content-type: text/html\n\n @tmp \n";

}


sub f_error {           # Fatal error handling: messages to STDERR and STDOUT
   if( $DEBUG) {
       print "Fatal Error: $_[0]  at line $_[1] in file $_[2]\n";
       die;
   }
   else {
       print "Content-type: text/html\n\n";
       print "<html>\n<head>\n<title>Error In CGI Program</title>\n";
       print "<body>\n<h1>Error In CGI Program</h1>\n";
       print "Fatal error  at line $_[1] in file $_[2]. This was probably caused by one of the following:\n<UL>";
       print "<li>Trying to delete an already deleted notice\n";
       print "<li>Trying to view a deleted notice (you can't see what isn't there...)\n";
       print "</ul>\n<p> If the problem persists, and does not seem to fall under these \ncategories, please inform \n";
       print "The managers of the notices system package of this problem.";
       print "<hr><p align=right><em>Web</em>Notice\n</body>\n</html>";
       die "Fatal Error: $_[0] at line $_[1] in file $_[2] \n";
   }
}
                               # Return error message if the user forgot
			       # to select a department.

sub no_file_specified  {
   print 
"Content-type: text/html\n\n
<HTML> 
<HEAD> <TITLE> ** No File Selected! </TITLE> </HEAD> 
<BODY>
<H2> ** No File Selected ** </H2> <p> You accessed this document without
specifying a notice to be modified or deleted.  Please start from the 
Notices selection page to properly select a notice.
</BODY> 
</HTML>";
   die "";
}

sub no_dept_specified  {
   print 
"Content-type: text/html\n\n
<HTML> 
<HEAD> <TITLE> ** No Department Selected! </TITLE> </HEAD> 
<BODY>
<H2> ** No Department Selected ** </H2> <p> You did not select a department.
Press the browser's <em>back</em> button to return to the departmental
selection page, and select the department for which you want to
submit a seminar notice. 
</BODY> 
</HTML>";
   die "";
}

sub get_group_info  {

#  Open the Primary Seminar Groups information database and return an
#  associative array giving the full group/department names corresponding 
#  to each short name.

   local($db_file, *dept_list) = @_;
   local( @tmp);

   if( !( -e $db_file) ) {
      &f_error("File $db_file does not exist.\n",__LINE__,__FILE__);
   }
   elsif( !( -r $db_file) ) {
      &f_error("File $db_file exists but is not readable.\n",__LINE__,__FILE__);
   }

   open(DBASE, $db_file) ||
		  &f_error("Unable to open database.\n",__LINE__,__FILE__);

   while(<DBASE>) {
      s/\s/ /g;                    # convert tabs to single space
      s/ +/ /g;                    # remove multiple space characters
      s/ *: */:/g;                 # remove leading/trailing blanks before :
      s/^ +//g;                    # remove leading blanks
      if( !(/^ *#/)  && /\S/ ) {   # skip comment lines
        @tmp=split(":",$_);
        $dept_list{"$tmp[0]"}=$tmp[1];
      }
   }
   close(DBASE);
}


sub scan_db_file {   
                        # Scan the Secondary Seminar Notices group database 
			# file and extract inforation relevant to the 
			# selected department.
 
#  Arguments:
#
#         $filename       - secondary database file to be opened and read.
#         $dept           - Department code
#  Returned quantities:
#         @division_keys  - Array of divisional keys 
#         %user_id        - associative array for authorized user ids.
#         %listserv       - associative array for listserv names.
#         %newsgrps       - associative array for newsgroup names.

   local ($filename, $dept, *division_keys, *user_id, *listserv, *newsgrps)= @_;
   local (@db_entry, $tmp,   $outside, $inside);
   local ($id,       $organ, $list,    $news);

   if($DEBUG) { print "Opening file $filename \n"; }

   $outside = $TRUE;
   $inside  = $FALSE;

   @db_entry = ();
   %user_id  = ();
   %listserv = ();
   %newsgrps = ();

   if( $DEBUG ) { print "Open database file $filename,   Dept = $dept\n"; }

   open(DB_FILE, "< $filename");
   while ($outside) {
      if ($_ = <DB_FILE>) {
	 if( $DEBUG ) { print "Outside = $outside, Inside = $inside, Input line = $_ \n"; }
	 if( /\<$dept\>/ && !(/^ *#/) ) {
	    $outside = $FALSE;
	    $inside  = $TRUE;
	    while( $inside ) {
	      if( $_ = <DB_FILE> ) {
	         if( $DEBUG ) { print "Outside = $outside, Inside = $inside, Input line = $_ \n"; }
		 if (/\<\/$dept\>/ && !(/^ *#/) ) {
		   $inside=$FALSE;
                 }
		 else {
                   if( !(/^ *#/)  && /\S/ ) {   
	               push(@db_entry, $_);  # skip empty & comment lines.
		       if($DEBUG) { print "Line to Entry = $_\n"; }
                   }
                 }
              }
	      else {
		 &f_error("Database entry -:$dept:- ended prematurely\n",__LINE__,
		 __FILE__);
              }
	    }
	 }
      }
      else {
	 &f_error("Database entry -:$dept:- is not present \n",__LINE__,
	 __FILE__);
      }
   }
   close(DB_FILE);

   foreach $_ (@db_entry) {
      s/\s*:\s*/:/g;
      s/\n//;
      ($organ, $id, $list, $news) = split(":",$_);
      if($DEBUG) { print "Organ = $organ,  Listserv=$list,  news=$news\n\n";}
      push(@division_keys, $organ);
      $user_id{$organ}  = $id;
      $listserv{$organ} = $list;
      $newsgrps{$organ} = $news;
   }

}
1;
