
# #!/usr/local/bin/perl

#  require 'timelocal.pl';

# $DEBUG = 1;   #   Flag for debug printing
 
#  $start  = 1;
#  $length = 6;
  
#  print "Test 1 -- Testing Starting Dates\n";
#  while ($start > -30 ) {
#   $start--;
#   if (&time_interval($start, $length, *a, *b, *c, *d, *err)) {
#     print "  Start = $start, Len = $length, Start=$b, Stop=$d\n";
#   } 
#  }
# 
#  $start = 1;
#  $length = -1;
#  print "\n\nTest 2 -- Testing Year-Intervals\n";
#  &time_interval($start, $length, *a, *b, *c, *d, *err);
#  print "Start = $start, Len = $length, Start=$b, Stop=$d\n";
# 


sub time_interval {

# Program time_interval.pl 
# Version 1.1
# Copyright Ian Graham,  November 1995
# More bla bla.

# This function takes as input a starting day of the week (0-6 = Sunday to
# Saturday) and an interval in number of days, and returns four quantities:
#
# $fname_start - Beginning filename for notices lying in the interval
# $date_start  - Formatted date for beginning of interval
# $fname_stop  - Stopping filename for notices lying in the dinterval
# $date_stop   - Formatted date for last possible filename of interval

# The function returns a value of 1 if succesful, and 0 if not -- $err
# then contains a relevant error message.

#  -------------------------------------------------------------------

# ARGUMENTS 
#   $start        - starting day of week for interval 0=sunday, 6=saturday
#                   Special Values
#		       0: Start at previous Sunday
#		       1: Start at previous Monday
#		       7: Start at next Sunday
#		       8: Start at next Monday
#   $length       - duration of interval in days (integer)
#                   Special Values
#                     -1: Events for next year
#                      0: A single day
#                      6: A week long interval

# RETURNED QUANTITIES
#   $fname_start  -   Starting filename
#   $fname_stop   -   Stopping filename
#   $date_start   -   Starting date 
#   $date_stop    -   Stopping date
#   $error        -   Error message string

# RETURN VALUE
#   $e_flag       -   Error flag - function value

# This subroutine returns the starting and stopping filenames for

  local($start, 
        $length,
	*fname_start, 
	*date_start, 
	*fname_stop, 
	*date_stop,
	*error)  =  @_;

  local(@char_arr, $sec,   $min,  $hour,  $mday,  $mon,
        $year,     $wday,  $yday, $isdst, $s_sec, $s_min,
        $s_hour,   $s_mday,$s_mon,$s_year,$s_wday,$s_yday,
	$s_isdst,  @weekday,      @month);

  @char_arr = ("00", "01", "02", "03", "04", 
	       "05", "06", "07", "08", "09");

  @weekday  = ("Sunday",   "Monday",  "Tuesday",  "Wednesday",  
	       "Thursday", "Friday",  "Saturday");

  @month    = ("Jan", "Feb", "Mar", "Apr", "May", "Jun",
	       "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" );

  $error = "";

  if($DEBUG) {print "     Time_interval: Start=$start, Length=$length\n"; }

                                          # Get current date
  ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time());

  $mday = $mday - $wday + $start;         # Get start time for list

  if($DEBUG) {print "     Time_interval: Starting mday=$mday, Year=$year\n"; }

  $time = &timelocal($sec,$min,$hour,$mday,$mon,$year);
  ($s_sec,$s_min,$s_hour,$s_mday,$s_mon,$s_year,$s_wday,$s_yday,$s_isdst)
         = localtime($time);

                                          # Convert to 4 digit year
  $s_year      += ($s_year < 70) ? 2000 : 1900;  
  $s_mon       = $char_arr[$s_mon]   if $s_mon    < 10;
  $s_mday      = $char_arr[$s_mday]  if $s_mday   < 10;
  $fname_start = $s_year.$s_mon.$s_mday."-0000.0000";
  $date_start  = $s_mday."-".$month[$s_mon]."-".$s_year;
  
  if ($length == -1) {
     $year++;
  }
  else {
     $mday += $length;
  }

  if($DEBUG) {print "     Time_interval: Ending   mday=$mday, Year=$year\n"; }
  
  $time = &timelocal($sec,$min,$hour,$mday,$mon,$year);
  
  ($s_sec,$s_min,$s_hour,$s_mday,$s_mon,$s_year,$s_wday,$s_yday,$s_isdst)
         = localtime($time);
                                          # Convert to 4 digit year
  $s_year      += ($s_year < 70) ? 2000 : 1900;  
  $s_mon       = $char_arr[$s_mon]  if $s_mon  < 10;
  $s_mday      = $char_arr[$s_mday] if $s_mday < 10;
  $fname_stop  = $s_year.$s_mon.$s_mday."-9999.9999";
  $date_stop   = $s_mday."-".$month[$s_mon]."-".$s_year;
  $e_flag = 1;
}
1;
