sub massage_time_and_date {

				 # This checks the contents of the
				 # $array{"date"} and $array{"time"}
				 # fields, and also creates a $num_date
				 # entry for use in generating notices.
				 #
				 # Errors messages (for return with the
				 # HTML document) are 'pushed' into the 
				 # array @pr_error

  require 'timelocal.pl';

  local(*num_date, *array, *pr_error) = @_;

  local($time, $date, $delta, @time_arr, @date_arr, %day_to_num);
  local(@s_months, @months, @days);

  @days        = ("Sunday",   "Monday",   "Tuesday",  "Wednesday", 
  	          "Thursday", "Friday",   "Saturday");

  %day_to_num  = ("sun",  0,  "mon",  1,  "tue", 2,  "wed", 3, 
	          "thu",  4,  "fri",  5,  "sat", 6);

  @months      = ("January",  "February", "March",     "April",
	          "May",      "June",     "July",      "August",
	          "September","October",  "November", "December");

  @s_months    = ("jan",  "feb",  "mar",  "apr",  "may",  "jun",
	          "jul",  "aug",  "sep",  "oct",  "nov",  "dec" );

  $time = $array{"time"};
  $date = $array{"date"};

  $time =~ s/\s//g;              # remove spaces from $time
  $date =~ s/[,.;:\-\_]/ /g;     # replace punctuation by spaces in $date
  $date =~ s/[\s]+/ /g;          # remove extra whitespace

# Process time first. The labelled while loop lets us "last" out of the 
# loop if errors are encountered in the time field.

TIME:  

  while(!defined($str)) {

    $delta = 0;
    if( $time =~ /\D*/ ) {         # trailing alphas? Look for AM, PM or H
         if( ($time =~ /pm$/i) || ($time =~ /p\.m\./i) ) {
   	      $str   = "PM";
       }
       elsif( ($time =~ /am$/i) || ($time =~ /a\.m\./i) ) {
	    $str   =  "AM";
       }
       elsif( $time =~ /h$/i) {
	    $str   = "H";
       }
       else {
	    push(@pr_error, 
"Error in the AM/PM field - Please specify the time in formats like 9:30 AM \n\
or 3:30PM (using AM or PM) or in the format 15:30h or 15:30 if using a 24 \n\
hour clock.\n");

	    last TIME;                    # Finished -- exit TIME loop
       }
    }

    $time     =~ s/[A-z]*//g;              # strip letter characters
    @time_arr = split(/[:-;.,]/, $time);   # split into hours and minutes

    if( $#time_arr != 1 ) {
        push(@pr_error, 
             "Error in the time of day: use a colon   $1 to \nseparate hours from minutes (e.g. 12:30 PM)  \n");
        last TIME;
    }

    if(($str eq "AM" || $str eq "PM") && 
       ($time_arr[0] < 1 || $time_arr[0] > 12) ) {
        push(@pr_error, "Error in the time field - Please specify the\ntime in formats like 9:30 AM or 3:30PM (using\nAM or PM) or in the format 15:30h or 15:30 if\nusing a 24 hour clock\n");
        last TIME;
    }

    if( $str ne "H" ) {
        if ($str eq "PM") {
	    if ($time_arr[0] == 12 ) { 
	        $delta = 0; 
	    }
            else {
	        $delta = 12; 
	    }
        }
          elsif ( ($str eq "AM") && ($time_arr[0] == 12) ) {
	    $delta = -12;
        }
    }
    $time_arr[0] +=  $delta;
    if( $time_arr[0] <= 6 ) {
	   push(@pr_warning, "This seminar starts before 7 in the morning -\nIs this actually reasonable?\n");
    }
    elsif( $time_arr[0] >= 23 ) {
	   push(@pr_warning, "This seminar starts after 11 in the evening -\nIs this actually reasonable?\n");
    }
  
    $hour = $time_arr[0];
    $min  = $time_arr[1];
    if( ( $min < 0) || ($min >= 60) ) {
	  push(@pr_error,"Error in the time field: minutes = $min, which is greater than or equal to 60\nor less than 0, which is not sensible\n");
    }
    $sec  = 0;
  
    if ($str eq "H") {
       if( $hour >= 12 ) {
	  $str = "PM";
	  if( $hour > 12) {$delta = 12;}
       }
       else {
	  $str = "AM";
	  if( $hour == 0) {$delta = -12;}
       }
    }   
  
    $array{"time"} = $time = ($hour-$delta).":".$min.$str;

  
  }                                   # END OF TIME 

#
# Now process the date -- First break into fields (space separated)
#
  
  @date_arr = split(/ /, $date);

  if( $#date_arr < 2 || $#date_arr > 3 ) {
      push(@pr_error, "Error in the date -- Please use a format \nlike <em>\"Monday 21 February 1995\"</em>,\n <em>\"21 Feb 1995\"</em> or similar.\n");
      return;
  }
  elsif( $#date_arr == 3) {            


DATE4:                  # The labelled while loop lets us "last" out of the 
                        # loop if errors are encountered in the date fields.

     while( !defined($indx) ) {
         if( $date_arr[3] =~ /\D/ || $date_arr[0] =~ /\d/ ) {
             push(@pr_error, "Error in the date -- Please use a format \nlike <em>\"Monday 21 February 1995\"</em>, \n<em>\"21 Feb 1995\"</em> or similar.\n");
             return;
         }
       
         $num_year = $date_arr[3];       # last field is Year
	 if( $num_year < 1900) {
             push(@pr_error, "Error in the date -- Please write the year in full, that is 1995, 2001, and so on.\n");
             return;
	 }
         $char_day = $date_arr[0];       # First field is weekdday (Monday, etc)
         $char_day =~ tr/A-Z/a-z/;
         $char_day =~ s/(...).*/$1/;
         $num_wday = $day_to_num{$char_day}; # convert weekday to number [0-6]

         if( $date_arr[1] =~ /\D/ ) {    # sort out order of day/month
	     if( $date_arr[2] =~ /\D/ ) {
                push(@pr_error, "Error in the date -- Please use a format \nlike <em>\"Monday 21 February 1995\"</em>,\n<em> \"21 Feb 1995\"</em> or similar.\n");
	        return;
             }
             $num_day = $date_arr[2];   # $date_arr[2] is day  (numeric) 
                                        # $date_arr[1] is month (string)
	     $indx = 0;	             
	     foreach (@s_months) {
	       if( $date_arr[1] =~ /$_/i )  {
                   $date_arr[1] = $months[$indx];
	           $num_month = $indx;
	           last DATE4;
               }
	       $indx++;
             }
             push(@pr_error, "Error in the date -- Please use a format \n like <em>\"Monday 21 February 1995\"</em>,\n<em> \"21 Feb 1995\" </em> or similar.\n");
	     return;
         }
         else {
	     if( $date_arr[2] !~ /\D/ ) {
               push(@pr_error, "Error in the date -- Please use a format \nlike <em>\"Monday 21 February 1995\"</em>,\n<em> \"21 Feb 1995\" </em> or similar.\n");
	       return;
             }
	     else {
               $num_day = $date_arr[1]; # $date_arr[2] is month (string)
	       $indx = 0;	        # $date_arr[1] is day  (numeric)
	       foreach (@s_months) {
	         if( $date_arr[2] =~ /$_/i )  {
                     $date_arr[2] = $months[$indx];
	             $num_month = $indx;
	             last DATE4;
                 }
	         $indx++;
               }
               push(@pr_error, "Error in the date -- Please use a format \nlike <em>\"Monday 21 February 1995\"</em>,\n<em> \"21 Feb 1995\" </em> or similar.\n");
	       return;
             }
         }
      }
      if($DEBUG) { 
	 print "\n\n***** DONE  *** ORIGINAL DATE FIELD = $date\n";
	 print "Date_arr[0] = $date_arr[0]   \
\	(char_day = $char_day --> num_wday = $num_wday)\n";
	 print "Date_arr[3] = $date_arr[3]    \
\	(num_year = $num_year)\n";
	 print "Date_arr[1] = $date_arr[1]\n";
	 print "Date_arr[2] = $date_arr[2]\n";
	 print "\nMonth counter= $num_month,  month day (num_day)= $num_day\n";
     }

#   End of DATE4 loop

     if($DEBUG) { print "  ORIGINAL FORMATTED  DATE = $date\n\n\n";  }
     $sectime = &timelocal(30,30,12,$num_day,$num_month,($num_year-1900));
     $num_weekday = (localtime($sectime))[6];
     if( $DEBUG) { print "Converted local day = $num_weekday\n"; }
     if($num_weekday ne $num_wday) {
	 push(@pr_error,"Error in the date.  The day of the week you gave is\nnot compatible with the date - please check your\ncalendar.\n");
	 return;
     }
     $array{"date"} = $date = 
	$days[$num_wday].", ".$num_day." ".$months[$num_month]." ".$num_year;
     if($DEBUG) { print "  NEWLY FORMATTED  DATE = $date\n\n\n";  }

	  
  }
 elsif( $#date_arr == 2) {            # Three Fields


DATE5:                  # The labelled while loop lets us "last" out of the 
                        # loop if errors are encountered in the date fields.

      while( !defined($indx) ) {
      if( $DEBUG) { print " \n\n**** DOING loop DATE5 ....\n"; }

         $num_year = $date_arr[2];       # last field is Year
	 if( $num_year < 1900) {
             push(@pr_error, "Error in the date -- Please write the year in full, that is 1995, 2001, and so on.\n");
             return;
	 }

         if( $DEBUG) { print " \n\n**** num_year = $num_year....\n"; }

         if( $date_arr[0] =~ /\D/ ) {    # sort out order of day/month
	     if($DEBUG) {print "Error 0.1\n";} 
	     if( $date_arr[1] =~ /\D/ ) {
                push(@pr_error, "Error in the date -- Please use a format \nlike <em>\"Monday 21 February 1995\"</em>,\n<em> \"21 Feb 1995\" </em> or similar.\n");
		if($DEBUG) {print "Error 1\n";} 
	        return;
             }
             $num_day = $date_arr[1];   # $date_arr[2] is day  (numeric) 
                                        # $date_arr[1] is month (string)
             if( $DEBUG) { print " \n\n**** num_day = $num_day....\n"; }
	     $indx = 0;	             
	     foreach (@s_months) {
	       if( $date_arr[0] =~ /$_/i )  {
                   $date_arr[0] = $months[$indx];
	           $num_month = $indx;
		   if($DEBUG) {print "Error 1 - num_month= $num_month\n";} 
	           last DATE5;
               }
	       $indx++;
             }
             push(@pr_error, "Error in the date -- Please use a format \nlike <em>\"Monday 21 February 1995\"</em>,\n<em> \"21 Feb 1995\" </em> or similar.\n");
	     if($DEBUG) {print "Error 2\n";} 
	     return;
         }
         else {
	     if($DEBUG) {print "Error p.3\n"; }
	     if( $date_arr[1] !~ /\D/ ) {
               push(@pr_error, "Error in the date -- Please use a format \nlike <em>\"Monday 21 February 1995\"</em>,\n<em> \"21 Feb 1995\" </em> or similar.\n");
		if($DEBUG) {print "Error 3\n";} 
	       return;
             }
	     else {
               $num_day = $date_arr[0]; # $date_arr[2] is month (string)
	       $indx = 0;	        # $date_arr[1] is day  (numeric)
	       if($DEBUG) {print " *** Error 3.2 - num_day = $num_day\n";} 
	       if($DEBUG) {print " *** Error 3.2 - indx = $indx\n";} 
	       foreach (@s_months) {
		 if($DEBUG) { print " ---- LOOP -- s_month = $_,  month=$date_arr[1]\n"; }
	         if( $date_arr[1] =~ /$_/i )  {
                     $date_arr[1] = $months[$indx];
	             $num_month = $indx;
		     if($DEBUG) { print " ---- inside if ------\n\n";}
	             last DATE5;
                 }
	         $indx++;
               }
               push(@pr_error, "Error in the date -- Please use a format \nlike <em>\"Monday 21 February 1995\"</em>,\n<em> \"21 Feb 1995\" </em> or similar.\n");
		if($DEBUG) {print "Error 4\n";} 
	       return;
             }
         }
      if( $DEBUG) { print " \n\n**** FINISHED loop DATE5 (A)....\n"; }
      }

      if( $DEBUG) { print " \n\n**** FINISHED loop DATE5 (B) ....\n"; }

      if($DEBUG) { 
	 print "\n\n***** DONE  *** ORIGINAL DATE FIELD = $date\n";
	 print "Date_arr[2] = $date_arr[2]    \
\	(num_year = $num_year)\n";
	 print "Date_arr[0] = $date_arr[0]\n";
	 print "Date_arr[1] = $date_arr[1]\n";
	 print "\nMonth counter= $num_month,  month day (num_day)= $num_day\n";
      }
      if($DEBUG) { print " THREE FIELDS --  ORIGINAL DATE = $date\n\n\n";  }
      $sectime = &timelocal(30,30,12,$num_day,$num_month,($num_year-1900));
      $num_wday = (localtime($sectime))[6];
      if($DEBUG) { print "Converted local day = $num_wday\n"; }
      $date =
	 $days[$num_wday].", ".$num_day." ".$months[$num_month]." ".$num_year;
      $array{"date"} = $date;
      if($DEBUG) { print " THREE FIELDS --  NEW DATE = $date\n\n\n";  }
  }
      if( $DEBUG) { print " \n\n**** FINISHED loop DATE5 (C) ....\n"; }
  $time_date_string = $num_year." ".$num_month." ".$num_day." ".$hour." ".$min." ".$sec;
  $array{"time_date_string"} = $time_date_string;
  $num_date = ($num_day)."-".($num_month+1)."-".($num_year-1900);
  if($DEBUG) { 
     print "time_date_string = $time_date_string,    Num_date = $num_date\n"; 
  }
		      
}
1;
