#! /usr/local/bin/perl
{
}
sub create_text_notice {                    

# This function creates an ASCII document equivalent for a notice. This
# can be then used for text-only e-mail distribution or for posting to
# a newsgroup.

# INPUT ARGUMENTS
#   %dept_list    Associative Array matching full Department Names to
#		  department keys.
#   %array        Associative Array containing all data from the database
#		  entry.

# RETURNED VALUES
#   @page 	  Array containing the text version of the notice.
#   $subject 	  String containing text to use as mail or news subject line.

# --------------------------------------------------------------------

  local($line_width, *dept_list, *array, *page, *subject) = @_;

  local($num_year, $num_month, $num_day, @tmp, $num_date);
  local($time_date);
  local($department);

  foreach(keys(%array)){
     $tmp = $array{$_};
     &isotoasc(*tmp);
     $array{$_} = $tmp;
  }

  $department = $dept_list{$array{"dept"}};

  if( $DEBUG ) { print " Made it to sponsor......\n"; }
   
					    # Create formatted date and time
					    # fields for TITLE and body of
					    # the notice.
  ($num_year, $num_month, $num_day, @tmp) = 
	   split(/ /,$array{"time_date_string"});
  $num_date  = ($num_day)."-".($num_month+1)."-".($num_year);
  $time_date = $array{"date"}." at ".$array{"time"};
  
                                            # If a subdepartment was specified
					    # add this information to the 
					    # department string 
  if( $array{"organ_type"} !~ /department/i ) {
     $department = $array{"organ_type"};
  }
  $subject = "UPDATE: $num_date, $department";

  if( $DEBUG ) { 
	 print " subject    = $subject\n"; 
	 print " Department = $department\n"; 
	 print " Num_date   = $num_date\n"; 
   }

  if( $DEBUG ) {  print "FOO.1 -- Event-type =  $array{\"event_type\"}\n"; }
  if( $DEBUG ) {  print "FOO.2 =  $foo\n"; }


  push(@page, &text_center($line_width, "** EVENT LISTSERV UPDATE **") );
  push(@page, "\n");
  push(@page, &text_center($line_width, $array{"event_type"}) );
  push(@page, "\n");
  push(@page, &text_center($line_width, $department) );
  push(@page, "\n");
  push(@page, &text_center($line_width, $time_date) );
  push(@page, "\n");
  push(@page, &text_center($line_width, $array{"locat"}) );
  push(@page, "\n");
  push(@page, &text_center($line_width,"-------" )  );
  push(@page, "\n");
  push(@page, &text_center($line_width, $array{"t_title"}) );
  push(@page, "\n");
  push(@page, &text_center($line_width, $array{"speak"}) );
  push(@page, "\n");
  $array{"affil"} =~ s/\n/<br>/g;
  push(@page, &text_center($line_width, $array{"affil"}) );
  push(@page, "\n\n");
  push(@page, &text_center($line_width, "ABSTRACT" ) );
  push(@page, "\n");
  $indent     = 5;
  $hangindent = 0;
  $para_pad = "\n";   # extra spacing between paragraphs
  push(@page, &align($indent, $hangindent, $para_pad,
		     $line_width, $array{"t_abstract"}) );
  push(@page, "\n");
  $indent = 0;
  $para_pad = "";     # extra spacing between paragraphs
  push(@page, &align($indent, $hangindent, $para_pad, 
		     $line_width, $array{"other_info"}) );
  push(@page, "\n");
  push(@page, &horiz_line(($line_width-2)) );
  push(@page, "\n");

  if( $DEBUG ) { print " Made it to sponsor......\n"; }

  if( $array{"sponsor"} =~ /\S+/ ) {
      push(@page, "Talk Sponsored by:    $array{\"sponsor\"}\n\n");
  }
  if( ($array{"info_name"}  =~ /\S+/) || ($array{"info_email"} =~ /\S+/) ||
      ($array{"info_phone"} =~ /\S+/) || ($array{"info_www"}   =~ /\S+/) ) {
      push(@page, "For Additional Information, Contact:\n");
      if( $array{"info_name"} =~ /\S+/)  {
	 push(@page, "   Name:    $array{\"info_name\"}\n");
      }
      if( $array{"info_email"} =~ /\S+/)  {
	 push(@page, "   E-mail:  $array{\"info_email\"}\n");
      }
      if( $array{"info_phone"} =~ /\S+/)  {
	 push(@page, "   Phone:   $array{\"info_phone\"}\n");
      }
      if( $array{"info_www"} =~ /\S+/)  {
	 push(@page, "   URL:     $array{\"info_www\"}\n");
      }
  }

}


# horiz_line,  text_center, align, indent

sub horiz_line  {
 local( $line_width) = @_;
 local( $string );
 $string = "-" x $line_width;
 $string .= "\n";
 return $string;
}

sub horiz_line_centred  {
 local( $page_width, $line_width) = @_;
 local( $string, $indent);
 $indent = ($page_width - $line_width)/2;
 $string = " "  x $indent;
 $string .= "-" x $line_width."\n";
 return $string;
}

sub text_center {
 local ($line_width, $input_string) = @_;
 local( $indent, $tmp, @strings);
 $indent=0;
 $input_string =~ s/%3e/>/g;
 $input_string =~ s/%3c/</g;
 $input_string =~ s/\n//g;
 $input_string =~ s/\<br\>/\n/gi;
# $input_string =~ s/\<\/[a-zA-Z]* *\>//g;
# $input_string =~ s/\<[a-zA-Z]*\S*\>//g;
 @strings = split("\n", $input_string);
 foreach $entry (@strings) {
    $len = length($entry);
    if($len < $line_width) {
       $diff  = ($line_width - $len)/2;
       $buf   = " " x $diff;
       $entry = $buf.$entry."\n";
    }
    else {
       $MORE_TO_SPLIT = $TRUE;;
       $string = $entry;
       $entry  = "";
       while( $MORE_TO_SPLIT ) {
          &splitline($string, $line_width, *tmp);
          $len = length($tmp[0]);
	  if($len < $line_width ) {
             $diff  = ($line_width - $len)/2;
          }
	  else {
	     $diff = "";
          }
          $buf    = " " x $diff;
          $tmp[0] = $buf.$tmp[0]."\n";
          $entry .= $tmp[0];
          if($#tmp == 1) { 
	     $string = $tmp[1];
          }
	  else {
	     $MORE_TO_SPLIT = $FALSE;
          }
       }
    }
  }

  $value = "";
  foreach (@strings) {
    $value .= $_;
  }
  return $value;
}

sub splitline  {

       local($string, $line_width, *array) = @_;
       local($len2, $len);
       @array = ();
       $len2 = length($string);
       if($len2 < $line_width ) {
	  $array[0] = $string;
       }
       else {
LOOP:     for ($len = $line_width ; $len >0; $len--) {
             if(substr($string, $len, 1) eq " ") {
               substr($string, $len, 1) = "\f";
               @array = split("\f", $string);
	       return;
             }
          }
          for($len = $line_width ; $len<=$len2; $len++) {
             if(substr($string, $len, 1) eq " ") {
               substr($string, $len, 1) = "\f";
               @array = split("\f", $string);
	       return;
             }
          }
	  $array[0] = $string;
	  $array[1] = "";
       }
}

sub align {
 local ($indent, $hangindent, $para_pad, $line_width, $input_string) = @_;

 local(@paragraphs, $entry, $len,    $string);
 local($leader,     $tmp,   @tmp,    $value);

 @paragraphs=();

 $local_width = $line_width - 2*$indent;
 $origleader = " " x $indent;
 $hangleader = " " x ($indent+$hangindent);

 $leader=$origleader;

 if($DEBUG) { print "Align: Input string: $input_string\n"; }
 if($DEBUG) { print "       Indent       = $indent      Line_width = $line_width\n"; }

 $input_string =~ s/%3e/>/g;                  # unencode URL encodings
 $input_string =~ s/%3c/</g;
 $input_string =~ s/(\r\n)/\n/g;              # Turn CRLF to \n
 $input_string =~ s/\r/ /g;                   # dump stray CRs
 $input_string =~ s/\t/ /g;                   # tabs to spaces
 $input_string =~ s/\f/ /g;                   # nasty formfeeds into spaces
# $input_string =~ s/  */ /g;                  # multiple spaces to single spaces
 $input_string =~ s/^ //;                     # remove leading blanks
 $input_string =~ s/ *<br> */\n\n/gi;         # line breaks to two line breaks
 $input_string =~ s/<br>/\n\n/gi;             #  "   "   "   "   "   "   "
 $input_string =~ s/\n( *\n)+/\n\n/g;         # turn 3+ newlines to 2 newlines
					      # or multinewlines with spaces 
					      # into newlines
 $input_string =~ s/([\w\W])\n([\w\W])/$1 $2/g; # concatenate paragraphs to 

# $input_string =~ s/ *<\/[a-zA-Z]* *> */ /g;
# $input_string =~ s/ *<[a-zA-Z]*\S*> */ /g;

 @paragraphs = split("\n", $input_string);
 foreach $entry (@paragraphs) {
    $leader = $origleader;
    $len = length($entry);
    if($DEBUG) { print "       LEN=$len,  TRUE=$TRUE, PARAGRAPH -:$entry:-\n"; }
    if($len < $local_width) {
       $entry = $leader.$entry."\n"; #################
    }
    else {
       $MORE_TO_SPLIT = $TRUE;
       $string = $entry;
       $entry  = "";
       while( $MORE_TO_SPLIT) {
          &splitline($string, $local_width, *tmp);
          $len = length($tmp[0]);
#          if($len <= $local_width) {
             $tmp[0] = $leader.$tmp[0]."\n";
#          }
          $entry .= $tmp[0];
          if($#tmp == 1) { 
	     $string = $tmp[1];
	     $leader=$hangleader;
          }
	  else {
	     $MORE_TO_SPLIT = $FALSE;
	     $entry .= $para_pad;    # -- space padding between paragraphs...
          }
       }
    }
    
 }
 $value = "";
 foreach (@paragraphs) {
    $value .= $_;
 }
 if($DEBUG){ print "Align: DONE...\n\n"; }
 return $value;
}

1;
