
sub create_notice {                         # read in template from $template,
					    # and use data from %array to 
					    # place in @page the document to
					    # return to the user.

  local($template, *dept_list, *hidden, *array, *page) = @_;

  local($num_year, $num_month, $num_day, @tmp, $num_date);
  local($time_date, $doc_title, $add_info, $one, $sponsor, @db_entry);
  local($department, $url, $other_info, $abstract);

  $department = $dept_list{$array{"dept"}};
   
					    # Read in notice template file
  open(TEMPLATE,$template) ||
         &f_error("Unable to open notice template: \n ", __LINE__,__FILE__);

  @page = <TEMPLATE>;
  close(TEMPLATE);
					    # Create formatted date and time
					    # fields for TITLE and body of
					    # the notice.
  ($num_year, $num_month, $num_day, @tmp) = 
	   split(/ /,$array{"time_date_string"});
  $num_date  = ($num_day)."-".($num_month+1)."-".($num_year);
  $time_date = $array{"date"}." at ".$array{"time"};
  $doc_title = $department." ".$array{"event_type"}." -- ".$num_date;
  
                                            # Create auxilliary fields for
					    # Talk sponsor and additional
					    # information (if present in the
					    # database).
  if( $array{"sponsor"} =~ /\S+/) {
       $sponsor="<p> <b>Talk sponsored by: <\/b><em>".$array{"sponsor"}."<\/em>";
}

  if( ($array{"info_name"}  =~ /\S+/) || ($array{"info_email"} =~ /\S+/) ||
      ($array{"info_phone"} =~ /\S+/) || ($array{"info_www"}   =~ /\S+/) ) {
      $add_info = "<p> <b>For Additional Information:</b>\n";
      if( $array{"info_name"} =~ /\S+/)  {
	  $add_info .= "\n<br>&#160;&#160;&#160;&#160;&#160; <b> Name: </b> <em>".$array{"info_name"}."<\/em>";
      }

      if( $array{"info_email"} =~ /\S+/)  {
#	  $add_info .= "\n<br>&#160;&#160;&#160;&#160;&#160; <b>E-mail: </b><em>".$array{"info_email"}."<\/em>";
	  $add_info .= "\n<br>&#160;&#160;&#160;&#160;&#160; <b>E-mail: </b><a href=\"mailto:".$array{"info_email"}."\"><em>".$array{"info_email"}."<\/em><\/a>";
      }

      if( $array{"info_phone"} =~ /\S+/)  {
	  $add_info .= "\n<br>&#160;&#160;&#160;&#160;&#160; <b>Phone: </b><em>".$array{"info_phone"}."<\/em>";
      }

      if( $array{"info_www"} =~ /\S+/)  {
	
	$add_info .= "\n<br>&#160;&#160;&#160;&#160;&#160; <b>URL: </b><a href=\"".$array{"info_www"}."\"><em>".$array{"info_www"}."<\/em></a>";
      }

  }

  if($time_date =~ /MOVED/) {
      $url = $rel_cgi_dir."list_full.pl?".$array{"link_to"};
      $time_date = "<A HREF=\"$url\">Notice Moved to a new Time</A>" ;
  }
                                            # patch affiliation string
					    # for possible multiple places
  $affil = $array{"affil"};
  $affil =~ s/\n+/<BR>and<BR>/g;

  $abstract = $array{"t_abstract"};         # replace multiple new lines in
  if( $DEBUG) { 
	 print "ORIGINAL \n";
	 print $abstract; 
  }
  $abstract =~ s/\n(\s*\n)+/<P>/g;           # abstract by a paragraph break.
  if( $DEBUG) { 
	 print "MODIFIED \n";
	 print $abstract; 
  }
                                            # If a subdepartment was specified
					    # add this information to the 
					    # department string 
  if( $array{"organ_type"} !~ /department/i) {
     $department = $department."<BR> $array{\"organ_type\"}";
  }
                                            # OK, now edit the template and 
					    # insert the blocks of text.
  foreach $one (@page) {                     

      $one =~ s/\<\!--.*-->//;
      
      $one =~ s/\<S_EVENT_TYPE\>/$array{"event_type"}/;
  
      $one =~ s/\<S_DOC_TITLE\>/$doc_title/;
      $one =~ s/\<S_DEPT\>/$department/g;
  
      $one =~ s/\<S_TIME_DATE\>/$time_date/;
      $one =~ s/\<S_LOCAT\>/$array{"locat"}/;
      $one =~ s/\<S_TITLE\>/$array{"t_title"}/;
      $one =~ s/\<S_SPEAK\>/$array{"speak"}/;
      $one =~ s/\<S_ABSTR\>/$abstract/;
      $one =~ s/\<S_AFFIL\>/$affil/;
  
      $one =~ s/\<S_OTHER_INFO\>/$array{"other_info"}/;
      $one =~ s/\<S_SPONSOR\>/$sponsor/;
      $one =~ s/\<S_INFO\>/$add_info/;

      $one =~ s/\<S_HIDDEN\>/@hidden/;
      $one =~ s/\<T_CGI_DIR\>/$cgi_dir/;
      $one =~ s/\<T_SECURE_CGI_DIR\>/$secure_cgi_dir/;

  }
}
1;
