#! /usr/local/bin/perl
#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
# 
# Permission to use, copy, modify and distribute without fee any portion 
# of this software and its documentation, for any purpose, is hereby granted 
# without fee, provided that (i) the above copyright notices and this 
# permission notice appear in all copies of the software and related 
# documentation, and (ii) the name of Ian Graham and The University of 
# Toronto may not be used in any advertising or publicity relating to 
# the software without the specific, prior written permission of Ian Graham.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
# 
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
# deposit_form.pl
#
# Revision:  1.0
# Date:      8 January 1995
# Author:    Ian Graham <ian.graham@utoronto.ca>
#
# This perl program is accessed from the Departmental selection page 
# generated by the program "add_notice.pl".  This program generates a
# department-specific seminar information input form. 

# Debug Use variable $DEBUG to set debug mode.

#$DEBUG = 1;


require 'lib/configure.ph';
require 'lib/utils.pl';


if ($DEBUG) {print "Content-type: text/plain\n\n"; } 
if ($DEBUG) {print "DEBUG MODE --\n"; }            

$input=$ENV{"QUERY_STRING"} if defined($ENV{"QUERY_STRING"}); 

if( $input !~ /dept=/) { 
   &no_dept_specified();                # User didn't select a department
}

$input =~ s/\+/ /g;                     # convert +'s to spaces
$input =~ s/dept=//;                    # remove NAME part of string
$input =~ s/%(..)/pack("c",hex($1))/ge; # convert URL hex codings to Latin-1


				# copy Department code to "hidden" element

$hidden_list .= "<INPUT TYPE=\"hidden\" NAME=\"dept\" VALUE=\"$input\">\n";

&get_group_info($db_file, *dept_list);
&scan_db_file($db_b_file,$input, *division_keys, 
	      *user_id, *listserv, *newsgrps);

$dept_label = $dept_list{$input};   # pick out this department's full name

# OK, we have the proper names for the departments: now generate, from the
# template document, the form to return to the user.

if( !( -e $deposit_form_tmpl) ) {
	&f_error("File $deposit_form_tmpl does not exist.\n",__LINE__,__FILE__);
}
if( !( -r $deposit_form_tmpl) ) {
	&f_error("File $deposit_form_tmpl exists but is not readable.\n", 
	           __LINE__, __FILE__);
}
      
open(TEMPLATE, $deposit_form_tmpl) ||
        &f_error("Unable to open $deposit_form_tmpl.\n", __LINE__,__FILE__);

@html_code = <TEMPLATE>;
close(TEMPLATE);

foreach (@html_code) {
   s/[\s]*<\!--.*-->[\s]*\n//g;       # delete all comment lines
   s/\<F_DEPARTMENT\>/$dept_label/;   # Department name (for title)
   s/\<F_HIDDEN_LIST\>/$hidden_list/g;# add Dept code hidden element 
   s/\<T_CGI_DIR\>/$cgi_dir/;         # add  cgi program base URL

   s/\<F_FORM_ERR\>//;                # Remaining fields should be blank
   s/\<F_TIME\>//;
   s/\<F_DATE\>//;
   s/\<F_LOCAT\>//;
   s/\<F_SPEAK\>//;
   s/\<F_AFFIL\>//;
   s/\<F_TITLE\>//;
   s/\<F_ABSTRACT\>//;  
   s/\<F_OTHER_INFO\>//;  
   s/\<F_SPONSOR\>//;  
   s/\<F_INFO_NAME\>//;  
   s/\<F_INFO_PHONE\>//;  
   s/\<F_INFO_E-MAIL\>//;  
   s/\<F_INFO_WWW\>//;  
   if( /\<F_EVENT_TYPE\>/) {
      $tmp = "<SELECT NAME=\"event_type\">";
      foreach $string (@event_type) {
	 $tmp .= "<OPTION>$string</OPTION>";
      }
      $tmp .= "</SELECT>\n";
      s/\<F_EVENT_TYPE\>/$tmp/;
   }
   if( /\<F_ORGAN_TYPE\>/) {
      $tmp = "<SELECT NAME=\"organ_type\">";
      foreach $string (@division_keys) {
	 $tmp .= "<OPTION>$string</OPTION>";
      }
      $tmp .= "</SELECT>\n";
      s/\<F_ORGAN_TYPE\>/$tmp/;
   }
}
                                        
print "Content-type: text/html\n\n";    # print the FORM to stdout
print "@html_code";
