#! /usr/local/bin/perl

#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
# 
# Permission to use, copy, modify and distribute without fee any portion 
# of this software and its documentation, for any purpose, is hereby granted 
# without fee, provided that (i) the above copyright notices and this 
# permission notice appear in all copies of the software and related 
# documentation, and (ii) the name of Ian Graham and The University of 
# Toronto may not be used in any advertising or publicity relating to 
# the software without the specific, prior written permission of Ian Graham.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
# 
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
# list_full.pl
#
# Revision:  1.0
# Date:      8 January 1995
# Author:    Ian Graham <ian.graham@utoronto.ca>

# Use DEBUG to set debug mode:  

#$DEBUG = 1;   # -------- Debug flag  

require 'lib/configure.ph';                 # Configuration parameters
require 'lib/read_db_file.pl';              # Read database file 
require 'lib/utils.pl';                     # Error output and misc. utilities
require 'lib/create_notice.pl';             # subroutine to generate notice

if ($DEBUG) {print "Content-type: text/plain\n\n"; }   
if ($DEBUG) {print "DEBUG MODE --\n\n"; }               

$filename=$ENV{"QUERY_STRING"};             # input (the name of the database
					    # file to display) comes from 
					    # query string;

					    # Decode URL syntax and create
					    # absolute path to file.
$filename      =~ s/\+/ /g;                 
$filename      =~ s/%(..)/pack("c",hex($1))/ge;  
$full_filename = $notice_dir."/".$filename;

$hidden[0]="<INPUT TYPE=\"hidden\" NAME=\"old_file_name\" VALUE=\"$filename\">";

if($DEBUG) { print " Full Filename = $full_filename\n"; }

&get_group_info($db_file, *dept_file);              # Read configuration 
						     # database
&read_db_file($full_filename, *array);               # Read db_file (to %array)
&create_notice($check_delete_notice_tmpl, *dept_file, *hidden, *array, *page); 
						     # Create notice in @page
&print_page(*page);                                  # Print the notice


