#! /usr/local/bin/perl
#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
# 
# Permission to use, copy, modify and distribute without fee any portion 
# of this software and its documentation, for any purpose, is hereby granted 
# without fee, provided that (i) the above copyright notices and this 
# permission notice appear in all copies of the software and related 
# documentation, and (ii) the name of Ian Graham and The University of 
# Toronto may not be used in any advertising or publicity relating to 
# the software without the specific, prior written permission of Ian Graham.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
# 
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
# cancel_notice.pl
#
# Revision:  1.0
# Date:      8 January 1995
# Author:    Ian Graham <ian.graham@utoronto.ca>


# Use variable $DEBUG to set debug mode..    

# $DEBUG = 1;


require 'lib/configure.ph';
require 'lib/utils.pl';
require 'lib/inverselist.pl';

if ($DEBUG) {print "Content-type: text/plain\n\n"; }   
if ($DEBUG) {print "DEBUG MODE --\n"; }               

&get_group_info($db_file, *dept_list);

&inverselist(*dept_list, *inverse_list);

@keylist =  sort(keys(%inverse_list));

$flag = 1;
foreach( @keylist ) {
   if( $flag)  {
      $flag = 0;
      push(@dept_list1,
           "<INPUT TYPE=\"radio\" NAME=\"dept\" VALUE=\"$inverse_list{$_}\"> &#160; $dept_list{$inverse_list{$_}}<br>\n");
   }
   else {
      $flag = 1;
      push(@dept_list2,
           "<INPUT TYPE=\"radio\" NAME=\"dept\" VALUE=\"$inverse_list{$_}\"> &#160; $dept_list{$inverse_list{$_}}<br>\n");
   }

}

push(@dept_list, "<table width=\"100%\" noborder><tr><td align=left><font size=\"-1\">\n");
foreach(@dept_list1) {
   push(@dept_list, $_);
}
push(@dept_list, "</font></td><td align=left><font size=\"-1\">\n");
foreach(@dept_list2) {
   push(@dept_list, $_);
}
push(@dept_list, "</font></td> </tr></table>\n");


#foreach( @keylist ) {
#   push(@dept_list,
#   "<INPUT TYPE=\"radio\" NAME=\"dept\" VALUE=\"$inverse_list{$_}\"> &#160; $dept_list{$inverse_list{$_}}<br>\n");
#}

open(TEMPLATE, $cancel_notice_tmpl) ||
       &f_error("Unable to open cancel_notice_template.\n",__LINE__,__FILE__);
@html_code = <TEMPLATE>;
close(TEMPLATE);

foreach (@html_code) {
   s/\<T_DEPT_LIST\>/@dept_list/g;      # add Dept codes and proper names
   s/\<T_DOC_DIR\>/$rel_doc_dir/g;      # add root directory to filenames
   s/\<T_CGI_DIR\>/$cgi_dir/g;          # add gateway program base URL
}

print "Content-type: text/html\n\n";    # print the FORM to stdout
print "@html_code";
