#! /usr/local/bin/perl
#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
# 
# Permission to use, copy, modify and distribute without fee any portion 
# of this software and its documentation, for any purpose, is hereby granted 
# without fee, provided that (i) the above copyright notices and this 
# permission notice appear in all copies of the software and related 
# documentation, and (ii) the name of Ian Graham and The University of 
# Toronto may not be used in any advertising or publicity relating to 
# the software without the specific, prior written permission of Ian Graham.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
# 
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
# OF THIS SOFTWARE.
# ----------------------------------------------------------------------
#
# add_notice.pl
#
# Revision:  1.0
# Date:      18 April 1995
# Author:    Ian Graham <ian.graham@utoronto.ca>
#
# This program generates (from the configuration file) a list of all
# registered Departments under which a notice can be posted - the user
# must select one of these to proceed. The gathered data (the Department
# submitting the notice) is passed to the program "deposit_form.pl" (which
# generates a FORM for inputting the notice) using an HTTP GET method --
# Therefore the URL pointing to the "deposit_form.pl" program can be stored 
# as a URL that links directly to a department-specific fill-in FORM.

# This program is accessed from the main control page ("notices_main.pl"), 
# but can also be accessed directly from a stored URL.  

# Debugging --  Use variable $DEBUG to set debug mode.

# $DEBUG = 1;

require 'lib/configure.ph';
require 'lib/utils.pl';
require 'lib/inverselist.pl';

if ($DEBUG) {print "Content-type: text/plain\n\n"; } 
if ($DEBUG) {print "DEBUG MODE --\n"; }            

&get_group_info($db_file, *dept_list);       # Get list of all registered
                                              # departments

&inverselist(*dept_list, *inverse_list);

@keylist =  sort(keys(%inverse_list));

$flag = 1;
foreach( @keylist ) {
   if( $flag)  {
      $flag = 0;
      push(@dept_list1,
	   "<INPUT TYPE=\"radio\" NAME=\"dept\" VALUE=\"$inverse_list{$_}\"> &#160; $dept_list{$inverse_list{$_}}<br>\n");
   }
   else {
      $flag = 1;
      push(@dept_list2,
           "<INPUT TYPE=\"radio\" NAME=\"dept\" VALUE=\"$inverse_list{$_}\"> &#160; $dept_list{$inverse_list{$_}}<br>\n");
   }
}
push(@dept_list, "<table width=\"100%\" noborder><tr><td align=left><font size=\"-1\">\n");
foreach(@dept_list1) {
   push(@dept_list, $_);
}
push(@dept_list, "</font></td><td align=left><font size=\"-1\">\n");
foreach(@dept_list2) {
   push(@dept_list, $_);
}
push(@dept_list, "</font></td> </tr></table>\n");



#foreach( @keylist ) {
#   push(@dept_list,
#   "<INPUT TYPE=\"radio\" NAME=\"dept\" VALUE=\"$inverse_list{$_}\"> &#160; $dept_list{$inverse_list{$_}}<br>\n");
#}
#------------------

# foreach( keys(%dept_array) ) {                # generate HTML list of Depts,
#   push(@dept_list,                           # associated with checkboxes
#   "<INPUT TYPE=\"radio\" NAME=\"dept\" VALUE=\"$_\"> &#160; $dept_array{$_}<br>\n");
#}

# OK, we have the keys and proper names for the departments: now generate,
# from the HTML template document add_notice_tmpl, the document to 
# return to the user.

if( !( -e $add_notice_tmpl) ) {
   &f_error("Department selection template does not exist.\n", 
	     __LINE__,__FILE__);
}
if( !( -r $add_notice_tmpl) ) {
   &f_error("Department selction template exists but is not readable.\n", 
	    __LINE__, __FILE__);
}
      
open(TEMPLATE, $add_notice_tmpl) ||
 &f_error("Unable to open Department selection template.\n", __LINE__,__FILE__);
@html_code = <TEMPLATE>;
close(TEMPLATE);

foreach (@html_code) {
   s/\<T_DEPT_LIST\>/@dept_list/g;     # add Departments to checkbox list.
   s/\<T_DOC_DIR\>/$rel_doc_dir/g;     # add relative directory path
				       # to HTML help files
   s/\<T_CGI_DIR\>/$cgi_dir/g;         # add base URL path for gateway programs.
}
                                        
print "Content-type: text/html\n\n";   # print the FORM to stdout
print "@html_code";

