#! /usr/local/bin/perl 
#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
# 
# Permission to use, copy, modify and distribute without fee any portion 
# of this software and its documentation, for any purpose, is hereby granted 
# without fee, provided that (i) the above copyright notices and this 
# permission notice appear in all copies of the software and related 
# documentation, and (ii) the name of Ian Graham and The University of 
# Toronto may not be used in any advertising or publicity relating to 
# the software without the specific, prior written permission of Ian Graham.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
# 
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
# 
# modify_field.pl 
# 
# Ian Graham <ian.graham@utoronto.ca>, Jan 1995

#
#

#$DEBUG=1;

if( $DEBUG) {print "Content-type: text/plain\n\n"; }
if( $DEBUG) {print "DEBUG ....\n"; }


require   '../cgi-reg/lib/configure.ph';
require   './lib/config_adm.ph';
require   '../cgi-reg/lib/utils.pl';
require    './lib/utils.pl';

if ($DEBUG) { print "read and processed database \n"; }

$input=<STDIN>;                          # read FORM data from stdin 
$input =~ s/\s*$//;                      # remove any trailing whitespace
@fields=split("&",$input);               # split data into separate fields

if ($DEBUG) { print "read stdin fields are:  @fields\n"; }

foreach $one (@fields) {
   ($name, $value) = split("=",$one);
   $name  =~ s/\+/ /g;                     # convert +'s to spaces
   $name  =~ s/%(..)/pack("c",hex($1))/ge; # convert URL hex codings to Latin-1
   $value =~ s/\+/ /g;                     # convert +'s to spaces
   $value =~ s/%(..)/pack("c",hex($1))/ge; # convert URL hex codings to Latin-1
   $name  =~ s/%3e/>/g;
   $name  =~ s/%22/"/g;
   $value =~ s/%3e/>/g;
   $value =~ s/%22/"/g;
   $array{"$name"} = $value;               # Place name/value pairs in 
					   # associative array "array".
}

# There should be two passed arguments:
#   $name = "dept"       (for the department)  value = departmental key
#   $name = "group_name" (for the group)       value = full group name
					 
# Check form fields dept and group_name -- they should not be empty.
# Error information is pushed into the @pr_error.

if( $array{"dept"} !~ /\S+/) {
  push(@pr_error, "You did not choose a Department or Faculty.");
}
if( $array{"group_name"} !~ /\S+/) {
  push(@pr_error, "You did not choose a Group to Modify/Add.");
}

                                    # If errors say so. If not, go ahead.
if( defined(@pr_error) ) {
   if ($DEBUG) {   print "PR_ERROR IS DEFINED --------\n"; }
   if ($DEBUG) {   print "PR_EROR = @pr_error\n"; }
   push(@form_err, "<HTML><HEAD><TITLE>Error in Input Fields</TITLE></HEAD>\n");
   push(@form_err, "<BODY>\n");
   push(@form_err, "<H1> Errors on Input Fields</H1>\n");
   push(@form_err, "We have detected problems with the input fields in");
   push(@form_err, "your page.\n These errors were (approximately):\n <UL> ");
   push(@form_err, "<LI> $tmp\n") while defined($tmp = pop(@pr_error));
   push(@form_err, "</UL> <P> Please Press the browser's <em>back</em> \n");
   push(@form_err, " button to return to the selection page. <HR>\n");
   push(@form_err, "</BODY></HTML>\n");
   &print_page(*form_err);
}

                                         # Place all name/value pairs in
                                         # hidden element array for inclusion
@fields = keys(%array);                  # with formatted seminar notice.
$sh_hidden = "";
foreach (@fields) {
 $tmp = $array{$_};
 $tmp =~ s/>/%3e/g;
 $tmp =~ s/"/%22/g;
 $sh_hidden .= "<INPUT TYPE=\"hidden\" NAME=\"$_\" VALUE=\"$tmp\">\n";
}

if ($DEBUG) {  print "PR_ERROR IS ***NOT*** DEFINED --------\n"; }


&get_group_info($db_file, *dept_list);
&scan_db_file_secure($db_b_file, $array{"dept"}, *group_names,
	      *user_id, *listserv, *newsgrps, *auth_user);

$department = $dept_list{$array{"dept"}};

$user = $ENV{"REMOTE_USER"};               # Name of user requesting change
if( $auth_user !~ /$user/) { &not_authorized($user); }

&get_group_list($groups_file, *tmp_list);  # Get full list of groups

#$DEBUG=1;

if( $DEBUG ) { 
   print "Content-type: text/plain\n\n"; 
   print "Group is: $array{\"group_name\"}\n -- FOO\n"; 
}

$new_group = 0;
$groupname = $array{"group_name"};
if( $groupname !~ /Department/) {
   $tmp = ""; 
   foreach (@group_names) { $tmp .= $_; }
   if($tmp !~ $groupname) { $new_group = 1; }
}


if($new_group) {
  $group_label = "Adding Group:<em> ".$groupname."</em>";
}
else {
  $group_label = "Modifying Group:<em> ".$groupname."</em>";
}


open(TEMPLATE, $modify_field_tmpl) ||
  &f_error("Unable to open template $modify_field_tmpl\n ",__LINE__,__FILE__);
  @form = <TEMPLATE>;
close(TEMPLATE);


foreach (@form) {
  s/\<\!--.*--\>//;
  s/\<F_HIDDEN>/$sh_hidden/;
  s/\<F_DEPARTMENT>/$department/;
  s/\<F_GROUP_LABEL>/$group_label/;
  s/\<F_GROUP_NAME>/$groupname/;
  s/\<F_GROUP_USERS>/$user_id{$groupname}/;
  s/\<F_GROUP_LISTSERV>/$listserv{$groupname}/;
  s/\<F_GROUP_USENET>/$newsgrps{$groupname}/;
  s/\<T_ADM_DIR\>/$adm_cgi_dir/;
  s/\<T_CGI_DIR\>/$cgi_dir/;

}

if($DEBUG) {  print "After Read. FORM = @form \n"; }
if($DEBUG) {  print "After Read. modify_field_tmpl = $modify_field_tmpl"; }

&print_page(*form);

