#! /usr/local/bin/perl 
#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
# 
# Permission to use, copy, modify and distribute without fee any portion 
# of this software and its documentation, for any purpose, is hereby granted 
# without fee, provided that (i) the above copyright notices and this 
# permission notice appear in all copies of the software and related 
# documentation, and (ii) the name of Ian Graham and The University of 
# Toronto may not be used in any advertising or publicity relating to 
# the software without the specific, prior written permission of Ian Graham.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
# 
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
# 
# make_changes.pl 
# 
# Ian Graham <ian.graham@utoronto.ca>, Jan 1995

#$DEBUG=1;

if( $DEBUG) {print "Content-type: text/plain\n\n"; }
if( $DEBUG) {print "DEBUG ....\n"; }


require   '../cgi-reg/lib/configure.ph';
require   './lib/config_adm.ph';
require   '../cgi-reg/lib/utils.pl';
require   './lib/utils.pl';
require   'ctime.pl';

if ($DEBUG) { print "read and processed database \n"; }

$input=<STDIN>;                          # read FORM data from stdin 
$input =~ s/\s*$//;                      # remove any trailing whitespace
@fields=split("&",$input);               # split data into separate fields

if ($DEBUG) { print "read stdin fields are:  @fields\n"; }

foreach $one (@fields) {
   ($name, $value) = split("=",$one);
   $name  =~ s/\+/ /g;                     # convert +'s to spaces
   $name  =~ s/%(..)/pack("c",hex($1))/ge; # convert URL hex codings to Latin-1
   $value =~ s/\+/ /g;                     # convert +'s to spaces
   $value =~ s/%(..)/pack("c",hex($1))/ge; # convert URL hex codings to Latin-1
   $name  =~ s/%3e/>/g;
   $name  =~ s/%22/"/g;
   $value =~ s/%3e/>/g;
   $value =~ s/%22/"/g;
   $array{"$name"} = $value;               # Place name/value pairs in 
					   # associative array "array".
}

# There must be five FORM variables:
#   $name = "dept"       (for the department)  value = departmental key
#   $name = "group_name" (for the group)       value = full group name
#   $name = "users"      (for the group)       value = list of authorized users
#   $name = "listserv"   (for the group)       value = list of listservs
#   $name = "news"       (for the group)       value = list of newsgroups
					 
# Check form fields dept and group_name -- they should not be empty.
# Error information is pushed into the @pr_error.

if( $array{"dept"} !~ /\S+/) {
  push(@pr_error, "Somehow you did not choose a Department or Faculty.");
}
if( $array{"group_name"} !~ /\S+/) {
  push(@pr_error, "Somehow you did not choose a Group to Modify or Add.");
}

$user   = $ENV{"REMOTE_USER"};
&scan_db_file_secure($db_b_file, $array{"dept"}, *group_names,
	      *user_id, *listserv, *newsgrps, *auth_user);
if( $auth_user !~ /$user/) { &not_authorized($user); }

$path = $adm_cgi_dir."add_user.pl";
&valid_user( $array{"users"}, *invalid );
if( $invalid ne "" ) {
   if($DEBUG) { print "USER_ID: Invalid = $invalid\n"; }
  $tmp = "The usernames &#160;<em> $invalid </em>&#160; are not registered. To register new usernames, please access the <A HREF=\"$path\">user addition</a> page.\n";
  push(@pr_error, $tmp);
}

&valid_listserv( $array{"listserv"}, *invalid );
if( $invalid ne "" ) {
   if($DEBUG) { print "LISTSERV:  Invalid = $invalid\n"; }
   $tmp = "The listserv(s) &#160;<em>$invalid</em>&#160; are not registered.  Please contact the Notices administrator to have these groups added to the system.\n";
   push(@pr_error, $tmp);
}

&valid_news( $array{"news"}, *invalid );
if( $invalid ne "" ) {
   if($DEBUG) { print "NEWS:  Invalid = $invalid\n"; }
   $tmp = "The newsgroup(s)&#160; <em>$invalid</em>&#160; are not registered. Please contact the Notices administrator to have these groups added to the system.\n";
   push(@pr_error, $tmp);
}

# If errors say so, and die. If not, go ahead.

if( defined(@pr_error) ) {
   $path = $cgi_dir."admin_main.pl";
   if ($DEBUG) {   print "PR_ERROR IS DEFINED --------\n"; }
   if ($DEBUG) {   print "PR_EROR = @pr_error\n"; }
   push(@form_err, "<HTML><HEAD><TITLE>Error in Input Fields</TITLE></HEAD>\n");
   push(@form_err, "<BODY>\n");
   push(@form_err, "<H1> Errors on Input Fields</H1>\n");
   push(@form_err, "Somehow there are problems with the input fields in");
   push(@form_err, "your submitted data.\n These errors were (approximately):\n <UL> ");
   push(@form_err, "<LI>$tmp\n") while defined($tmp = pop(@pr_error));
   push(@form_err, "</UL> <P> You will see this information if you are\n");
   push(@form_err, " improperly accessing this page. The starting point is\n");
   push(@form_err, " the <a href=\"$path\">Admin home</a> page.\n");
   push(@form_err, "</BODY></HTML>\n");
   &print_page(*form_err);
   die;
}

if ($DEBUG) {  print "PR_ERROR IS ***NOT*** DEFINED --------\n"; }

&get_group_list($groups_file, *tmp_list);  # Get full list of groups
&get_group_info($db_file, *dept_list);
$department = $dept_list{$array{"dept"}};

$new_entry = $array{"group_name"}." : ".$array{"users"}." : ".$array{"listserv"}." : ".$array{"news"}."\n";


$exec_string = "cp $db_b_file $db_b_file".".bak";
system($exec_string);

open(DBASE, "< $db_b_file") ||
   &f_error("Unable to open database $db_b_file\n ",__LINE__,__FILE__);

if($DEBUG) { print "...... Open, now lock database file $db_b_file\n"; }

if( !flock(DBASE, 2) ) {    
   &f_error("Unable to lock database $db_b_file\n ",__LINE__,__FILE__);
}

@dbase = <DBASE>;
close(DBASE);

if($DEBUG) { print "Content-type: text/plain\n\n"; }
if($DEBUG) { print "...... Read database file $db_b_file\n"; }
if($DEBUG) { print "...... Contents are: @dbase\n"; }

$start = 0;
$stop  = 0;

open(DBASE, "> $db_b_file") ||
   &f_error("Unable to open database $db_b_file\n ",__LINE__,__FILE__);
# seek(DBASE,0,0);
if($DEBUG) { print "...... SEEKEd origin \n"; }

foreach (@dbase) {
   if( / *\#/ ) {
       print DBASE "$_";
   }
   else {
      if( !$start ) { 
          print DBASE "$_";
          if(/<$array{"dept"}>/)  {$start = 1};
      }
      else {
         if( !$stop ) {
            if(/$array{"group_name"}/) {
	        print DBASE "$new_entry"; 
	        $stop = 1;
            }
            elsif ( /<\/$array{"dept"}>/ ) {
	       print DBASE "$new_entry";
	       print DBASE "$_";
	       $stop = 1;
            }
	    else {
	       print DBASE "$_";
	    }
         }
         else {
	    print DBASE "$_";
         }
      }
   }
}
      
if($DEBUG) { print "...... Rewrote database file $db_b_file\n"; }

flock(DBASE, 8);
close(DBASE);
if($DEBUG) { print "...... Unlocked database file $db_b_file\n"; }

$exec_string = "rm $db_b_file".".bak";
system($exec_string);
if($DEBUG) { print "...... Removed backup database file $db_b_file\n"; }

$date_str = &ctime(time);
chop($date_str);
$string   = "$date_str  Dept: $array{\"dept\"}, Changes by $user  Group: $array{\"group_name\"}  Auth_Users: $array{\"users\"}   Listservs: $array{\"listserv\"}   NewsGroups: $array{\"news\"}\n";
open(DBASE, ">> $passwd_log_file") ||
   &f_error("Unable to open log file $passwd_log_file\n ",__LINE__,__FILE__);
print DBASE "$string";
close(DBASE);

&get_group_info($db_file, *dept_list);
$department = $dept_list{$array{"dept"}};

open(TEMPLATE, $make_changes_tmpl) ||
  &f_error("Unable to open template $make_changes_tmpl\n ",__LINE__,__FILE__);
  @form = <TEMPLATE>;
close(TEMPLATE);


foreach (@form) {
  s/\<\!--.*-->//;
  s/\<F_DEPARTMENT>/$department/;
  s/\<F_GROUP_NAME>/$array{"group_name"}/;
  s/\<F_GROUP_USERS>/$array{"users"}/;
  s/\<F_GROUP_LISTSERV>/$array{"listserv"}/;
  s/\<F_GROUP_USENET>/$array{"news"}/;
}


&print_page(*form);

