
sub not_authorized {   
    local($name) = @_;

      print "Status: 401 Not Authorized\nContent-type: text/html\n\n
<html><head><title>Non-Authorised User</title></head><body>
<h2> Non-Authorized User </h2>
<p> I am sorry, but the user <em>$name</em> is not
authorized to modify this database.  Please contact your 
departmental adminstrative officer for more information. 
Unfortunately, if you made a mistake selecting the user
ID at the Username/password pop-up window you will have to exit
the browser and restart Mosaic or Netscape, as the user ID
cannot currently be modified from within the program.<hr> 
</body></html>";

die "";
}
sub get_group_list {   
#  Arguments:
#
#         $filename       - groups database file.
#
#  Returned quantities:
#         @group_list     - Array of group names (keys for assoc arrays)

   local ($filename, *group_list)= @_;

   if( $DEBUG ) { print "Open group file $filename<br>\n"; }

   open(DB_FILE, "< $filename");
   while(<DB_FILE>) {
	s/\s*$//;
        if( !(/^ *#/) ) {
           if( $DEBUG ) { print ".....Group = $_\n<br>"; }
           push(@group_list, $_);
        }
   }
   close(DB_FILE);
}

sub scan_db_file_secure {   
                        # Scan the Secondary Seminar Notices group database 
			# file and extract inforation relevant to the 
			# selected department.
 
#  Arguments:
#
#         $filename       - secondary database file to be opened and read.
#         $dept           - Department code
#  Returned quantities:
#         @division_keys  - Array of group names (keys for assoc arrays)
#         %user_id        - associative array for authorized user ids.
#         %listserv       - associative array for listserv names.
#         %newsgrps       - associative array for newsgroup names.
#         $auth_user      - whitespace separated list of authorized users.

   local ($filename, $dept, *division_keys, *user_id, *listserv, *newsgrps, *auth_user)= @_;
   local (@db_entry, $tmp,   $outside, $inside);
   local ($id,       $organ, $list,    $news);

   if($DEBUG) { print "Opening file $filename \n<br>"; }

   $outside = $TRUE;
   $inside  = $FALSE;

   @db_entry = ();
   %user_id  = ();
   %listserv = ();
   %newsgrps = ();

   if( $DEBUG ) { print "Open database file $filename,   Dept = $dept<br>\n"; }

   open(DB_FILE, "< $filename");
   while ($outside) {
      if ($_ = <DB_FILE>) {
	 if( $DEBUG ) { print "Outside = $outside, Inside = $inside, Input line = $_ \n"; }
	 if( /\<$dept\>/ && !(/^ *#/) ) {
	    $auth_user = $_;
	    $auth_user =~ s/\n//;
	    $auth_user =~ s/\r//;
	    $auth_user =~ s/\<$dept\>//;  # authorized users are listed after
	    $outside = $FALSE;
	    $inside  = $TRUE;
	    while( $inside ) {
	      if( $_ = <DB_FILE> ) {
	         if( $DEBUG ) { print "Outside = $outside, Inside = $inside, Input line = $_ \n"; }
		 if (/\<\/$dept\>/ && !(/^ *#/) ) {
		   $inside=$FALSE;
                 }
		 else {
                   if( !(/^ *#/)  && /\S/ ) {   
	               push(@db_entry, $_);  # skip empty & comment lines.
		       if($DEBUG) { print "Line to Entry = $_\n"; }
                   }
                 }
              }
	      else {
		 &f_error("Database entry $dept ended prematurely\n",__LINE__,
		 __FILE__);
              }
	    }
	 }
      }
      else {
	 &f_error("Database entry $dept is not present \n",__LINE__,
	 __FILE__);
      }
   }

   if ($auth_user !~ /\w+/ )  {
     $auth_user = "*(&23899~!#@;,.";     # random string if $auth_string
					   # not set.
   }


   foreach $_ (@db_entry) {
      s/\s*:\s*/:/g;
      s/\n//;
      ($organ, $id, $list, $news) = split(":",$_);
      if($DEBUG) { print "Organ = $organ,  Listserv=$list,  news=$news\n\n";}
      push(@division_keys, $organ);
      $user_id{$organ}  = $id;
      $listserv{$organ} = $list;
      $newsgrps{$organ} = $news;
   }
}

sub valid_user {
   local ($list, *invalid) = @_;
   local (@tmp, $valid_list, @names);
   $invalid = "";
   @names = split(/ +/, $list);
   if($DEBUG) { print "PASSWD CHECK - User passwd file $user_passwd_file\n"; }
   open(FILE, $user_passwd_file) ||
       &f_error("Unable to open password file \n ",__LINE__,__FILE__);
       @form = <FILE>;
   close(FILE);
   foreach (@form) {
      s/\s*$//;
      ($str1, $str2) = split(":", $_);
      if($DEBUG) {   print "    PASSWD  field1 = $str1,   field2=$str2\n"; }
      $valid_list .= $str1;
   }
   foreach (@names) {
      if ( $valid_list !~ /$_/ ) { $invalid .= $_; }
   }
   if($DEBUG) { print "PASSWD CHECK - Invalid = $invalid \n"; }
   
}

sub valid_listserv {
   local ($list, *invalid) = @_;
   local ($form_string, @items);

   open(FILE, $lists_file) ||
     &f_error("Unable to open listserv file: $lists_file\n",__LINE__,__FILE__);
   while( <FILE> ) { $form_string .= $_; };
   close(FILE);
   $form_string =~ s/\s/ /g;

   $invalid     = "";

   if($DEBUG) { print " LISTSERV CHECK -- form string = $form_string<br>\n"; }
   @items = split(/ +/, $list);

   foreach  (@items) {
     if( $form_string !~ $_ ) {
	$invalid .= $_." ";
     }
   }
   if($DEBUG) { print " LISTSERV CHECK -- invalid = $invalid <br>\n"; }
}

sub valid_news {
   local ($list, *invalid) = @_;
   local ($form_string, @items);

   open(FILE, $news_file) ||
     &f_error("Unable to open newsgroup file: $news_file\n",__LINE__,__FILE__);
   while( <FILE> ) { $form_string .= $_; };
   close(FILE);
   $form_string =~ s/\s/ /g;

   $invalid     = "";

   if($DEBUG) { print " NEWSGROUP CHECK -- form string = $form_string<br>\n"; }
   @items = split(/ +/, $list);

   foreach  (@items) {
     if( $form_string !~ $_ ) {
	$invalid .= $_." ";
     }
   }
   if($DEBUG) { print " NEWSGROUP CHECK -- invalid = $invalid <br>\n"; }

}
1;

