#! /usr/local/bin/perl
#
# ------------------------------------------------------------------------
# WebNotice --  Web/CGI Notice Posting Software
#
# Copyright (c) 1995 Ian Graham
#                    Information Commons
#                    University of Toronto
# 
# Permission to use, copy, modify and distribute without fee any portion 
# of this software and its documentation, for any purpose, is hereby granted 
# without fee, provided that (i) the above copyright notices and this 
# permission notice appear in all copies of the software and related 
# documentation, and (ii) the name of Ian Graham and The University of 
# Toronto may not be used in any advertising or publicity relating to 
# the software without the specific, prior written permission of Ian Graham.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
# 
# IN NO EVENT SHALL IAN GRAHAM OR THE UNIVERSITY OF TORONTO BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
# OF THIS SOFTWARE.
# ------------------------------------------------------------------------
#
#
# get_dept_info.pl
#
# Revision:  1.0
# Date:      8 January 1995
# Author:    Ian Graham <ian.graham@utoronto.ca>
#

# Debug Use variable $DEBUG to set debug mode.

#$DEBUG = 1;

require    '../cgi-reg/lib/configure.ph';
require   './lib/config_adm.ph';
require    '../cgi-reg/lib/utils.pl';
require    'lib/utils.pl';

if ($DEBUG) {print "Content-type: text/plain\n\n"; } 
if ($DEBUG) {print "DEBUG MODE --\n"; }            

$dept_key = $ENV{"QUERY_STRING"} if defined($ENV{"QUERY_STRING"}); 
$user     = $ENV{"REMOTE_USER"};

if( $dept_key !~ /dept=/) { 
   &no_dept_specified();                # User didn't select a department
}

$dept_key =~ s/\+/ /g;                     # convert +'s to spaces
$dept_key =~ s/dept=//;                    # remove NAME part of string
$dept_key =~ s/%(..)/pack("c",hex($1))/ge; # convert URL hex codings to Latin-1

				           # copy Department code to 
					   # "hidden" element

$hidden_list .= "<INPUT TYPE=\"hidden\" NAME=\"dept\" VALUE=\"$dept_key\">\n";

&get_group_info($db_file, *dept_list);
if($DEBUG) { print "DONE GROUP INFO.....\n"; }
&scan_db_file_secure($db_b_file, $dept_key, *group_names, 
	      *user_id, *listserv, *newsgrps, *auth_user);
if($DEBUG) { print "DONE SCAN_DB_FILE INFO.....\n";}

if( $auth_user !~ /$user/) { &not_authorized($user); }

&get_group_list($groups_file, *tmp_list);  # Get full list of groups

foreach $foo (@tmp_list) {
        $found=0;
LOOP:   foreach (@group_names) {
           if( $foo eq $_ ) { $found=1; last LOOP; }
        }
	if(!$found)  { push(@other_groups, $foo ); }
}
@tmp_list = ();

if($DEBUG) { 
    print "GOT OTHER_GROUPS LIST .....\n"; 
    foreach (@other_groups) { print "Group = $_\n"; }
}

$department = $dept_list{$dept_key};   # pick out this department's full name

# OK, we have the proper names for the departments: now generate, from the
# template document, the form to return to the user.

open(TEMPLATE, $get_dept_info_tmpl) ||
       &f_error("Unable to open template $get_dept_info_tmpl\n ",__LINE__,__FILE__);
@form = <TEMPLATE>;
close(TEMPLATE);
if($DEBUG) {  print "After Read. FORM = @form \n"; }
if($DEBUG) {  print "After Read. dept_info_tmpl = $get_dept_info_tmpl"; }


#
#  Construct Field for list of Departmental groups
#

LOOPX: foreach (@group_names) {
   if( /Department$/) {
     $info .= "<DT><INPUT TYPE=\"radio\", NAME=\"group_name\" ";
     $info .= " VALUE=\"$_\">&#160;<b>$_</b>\n<dd>";
     $info .= "<q>Authorized Users:</q> &#160; <em>$user_id{$_}</em> <BR>\n"; 
     $info .= "<q>Newsgroups:</q> &#160; <em>$newsgrps{$_}</em><br>\n";
     $info .= "<q>Listservs:</q> &#160; <em>$listserv{$_}</em><br><br>\n";
     last LOOPX;
   }
}

foreach  (sort @group_names) {
   if( !/Department$/) {
     $info .= "<DT><INPUT TYPE=\"radio\", NAME=\"group_name\" ";
     $info .= " VALUE=\"$_\">&#160;<b>$_</b>\n<dd>";
     $info .= "<q>Authorized Users:</q> &#160; <em>$user_id{$_}</em> <BR>\n"; 
     $info .= "<q>Newsgroups:</q> &#160; <em>$newsgrps{$_}</em><br>\n";
     $info .= "<q>Listservs:</q> &#160; <em>$listserv{$_}</em><br><br>\n";
   }
}

# Construct field for list of Other possible groups, currently not registered
# under this department.

foreach (sort @other_groups) {
   $other .= "<dt><INPUT TYPE=\"radio\", NAME=\"group_name\" ";
   $other .= " VALUE=\"$_\"> &#160; $_\n<dd>";
}

foreach (@form) {
   s/\s*\<\!--.*-->\s*\n//;
   s/\<F_HIDDEN\>/$hidden_list/;
   s/\<F_DEPT_INFO\>/$info/;
   s/\<F_DEPARTMENT\>/$department/;
   s/\<F_OTHER_GROUPS\>/$other/;
   s/\<T_ADM_DIR\>/$adm_cgi_dir/g;
   s/\<T_DOC_DIR\>/$rel_doc_dir/g;
}


print "Content-type: text/html\n\n";    # print the FORM to stdout
print "@form";
