#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <sys/signal.h>
#include <stdlib.h>
#include <time.h>

#include <sys/file.h>

#include "configure.h"

char *makeword(char *line, char stop);
char *fmakeword(FILE *f, char stop, int *len);
char x2c(char *what);
void unescape_url(char *url);
void plustospace(char *str);

char *crypt(char *pw, char *salt); /* why aren't these prototyped in include */


char *tn;

/* From local_passwd.c (C) Regents of Univ. of California blah blah */
static unsigned char itoa64[] =         /* 0 ... 63 => ascii - 64 */
        "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

to64(s, v, n)
  register char *s;
  register long v;
  register int n;
{
    while (--n >= 0) {
        *s++ = itoa64[v&0x3f];
        v >>= 6;
    }
}

void change_password(char *user, char *pw, FILE *f) {
    char *cpw, salt[3];

    (void)srand((int)time((time_t *)NULL));
    to64(&salt[0],rand(),2);
    cpw = crypt(pw,salt);
    free(pw);
    fprintf(f,"%s:%s\n",user,cpw);
}

void putline(FILE *f,char *l) {
    int x;

    for(x=0;l[x];x++) fputc(l[x],f);
    fputc('\n',f);
}

void print_err() {
    printf("Content-type: text/html%c%c",10,10);
    printf("<HTML><HEAD><TITLE>Error Found</TITLE>\n");
    printf("<BODY>\n<H1>Error Found</H1><hr size=5>\n");
}
    

main(int argc, char *argv[]) {
    register int x;
    int cl,found,create;
    char *u,*t1,*t2,*p1,*p2,*user, command[256], line[256], l[256], w[256];
    FILE *tfp, *f, *pfd;
    char *date;
    time_t clock;

    char *auth_user, *domain_name, *ip_addr;
    char *req_method, *content_type, *content_length;

    if( (auth_user   = getenv("REMOTE_USER")) == NULL ) {
	print_err();
	printf("<P>REMOTE_USER environment variable not defined.\n");
	printf("Please contact the WebNotices system administrator\n");
	printf("to report this problem.\n");
	printf("</BODY></HTML>\n");
    }
    if( (domain_name = getenv("REMOTE_HOST")) == NULL ) {
	print_err();
	printf("<P>REMOTE_HOST environment variable not defined.\n");
	printf("Please contact the WebNotices system administrator\n");
	printf("to report this problem.\n");
	printf("</BODY></HTML>\n");
    }
    if( (ip_addr     = getenv("REMOTE_ADDR")) == NULL ) {
	print_err();
	printf("<P>REMOTE_ADDR environment variable not defined.\n");
	printf("Please contact the WebNotices system administrator\n");
	printf("to report this problem.\n");
	printf("</BODY></HTML>\n");
    }

    tn = NULL;

/*     printf("Content-type: text/html%c%c",10,10);   */
    if( (req_method = getenv("REQUEST_METHOD")) == NULL) {req_method=" ";}
    if(strcmp(req_method, "POST")) {
	print_err();
        printf("<P>This script should be referenced with a METHOD of POST.\n");
        printf("If you don't understand this, see this ");
        printf("<A HREF=\"http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/Docs/fill-out-forms/overview.html\">forms overview</A>.</BODY></HTML>%c",10);
        exit(1);
    }
    if( (content_type = getenv("CONTENT_TYPE")) == NULL) {content_type=" ";}
    if(strcmp(content_type,"application/x-www-form-urlencoded")) {
	print_err();
        printf("This script can only be used to decode form results, \n");
        printf("and the data you sent arrived with the wrong \n");
        printf("Content-type. \n");
        printf("If you don't understand this, see this ");
        printf("<A HREF=\"http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/Docs/fill-out-forms/overview.html\">forms overview</A>.</BODY></HTML>%c",10);
        exit(1);
    }

    if( (content_length = getenv("CONTENT_LENGTH")) == NULL) {
	print_err();
        printf("CONTENT_LENGTH is undefined -- this implies an error \n");
        printf("on the part of your browser.\n");
        printf("</BODY></HTML>.\n");
	exit(1);
	 
    }
    else {
         cl = atoi(content_length);
    }

    user=NULL;
    p1=NULL;
    p2=NULL;
    create=0;
    for(x=0;cl && (!feof(stdin));x++) {
        t1 = fmakeword(stdin,'&',&cl);
        t2 = makeword(t1,'=');
        unescape_url(t1);
        unescape_url(t2);
        if(!strcmp(t2,"user")) {
            if(!user)
                user = t1;
            else {
	        print_err();
                printf("<P>This script was accessed from the wrong form.\n");
                printf("</BODY></HTML>.\n");
                exit(1);
            }
        }
        else if(!strcmp(t2,"newpasswd1")) {
            if(!p1)
                p1 = t1;
            else {
	        print_err();
                printf("<P>This script was accessed from the wrong form.\n");
                printf("</BODY></HTML>.\n");
                exit(1);
            }
        }
        else if(!strcmp(t2,"newpasswd2")) {
            if(!p2)
                p2 = t1;
            else {
	        print_err();
                printf("This script was accessed from the wrong form.\n");
                printf("</BODY></HTML>.\n");
                exit(1);
            }
        }
        else {
	    print_err();
            printf("This script was accessed from the wrong form.\n");
            printf("Unrecognized directive %s.\n",t2);
            printf("</BODY></HTML>.\n");
            exit(1);
        }
        free(t2);
    }
    u=getenv("REMOTE_USER");
    if((strcmp(user,u))) {
	    printf("Status: 401 Not Authorized\nWWW-Authenticate: Basic realm=\"RegPasswds\"\nContent-type: text/html\n\r\n\r");
            printf("<HTML><HEAD><TITLE>User Mismatch</TITLE></HEAD>\n");
            printf("<BODY> <H1>User Mismatch</H1>");
            printf("<hr size=5>The username you gave in the form does not\n ");
            printf("correspond with the username you used\n");
            printf("for authentication. Unfortunately you will have to \n");
            printf("exit the browser and restart it if you wish to choose\n");
	    printf("a different name for authentication.\n");
	    printf("<hr size=5></BODY></HTML>\n");
            exit(1);
        }
    if(strcmp(p1,p2)) {
	printf("Content-type: text/html%c%c",10,10);
        printf("<HTML><HEAD><TITLE>Password Mismatch</TITLE></HEAD>\n");
        printf("<BODY> <H1>Password Mismatch</H1><hr size=5>");
        printf("The two copies of your the password do not match. Please");
        printf(" try again.<hr size=5></BODY></HTML>");
        exit(1);
    }

    tn = tmpnam(NULL);
    if(!(tfp = fopen(tn,"w"))) {
        fprintf(stderr,"Change-passwd: Could not open temp file.\n");
        exit(1);
    }

    if(!(f = fopen(USER_FILE,"r"))) {
        fprintf(stderr,
                "Change-passwd: Could not open passwd file for reading.\n",USER_FILE);
        exit(1);
    }

    found = 0;
    while(!(getline(line,256,f))) {
        if(found || (line[0] == '#') || (!line[0])) {
            putline(tfp,line);
            continue;
        }
        strcpy(l,line);
        getword(w,l,':');
        if(strcmp(user,w)) {
            putline(tfp,line);
            continue;
        }
        else {
            change_password(user,p1,tfp);
            if(!(pfd = fopen(PASSWD_LOG,"a"))) {
               fprintf(stderr,"Change-passwd: Could not open password mods log file.\n");
            }
            else {
	       clock=time((time_t *)0);
	       date = ctime(&clock);
	       date[24]='\0';
               flock(pfd, LOCK_EX);
               fprintf(pfd,"%s  Password for %s -- Modified by %s, from host: %s, IP_address: %s\n", date, user, auth_user, domain_name, ip_addr);
               flock(pfd,LOCK_UN);
               fclose(pfd);
            }
            found=1;
        }
    }
    if(!found) {
       printf("Content-type: text/html%c%c",10,10);
       printf("<HTML><HEAD><TITLE>User Not Found</TITLE>");
       printf("<BODY><H1>User Not Found</H1><hr size=5>");
       printf("The username you entered is not registered in the \n");
       printf("password file. Press the browser's <em>back</em> \n");
       printf("to check if you mistyped the name.<hr size=5>\n"); 
       printf("</BODY></HTML>\n");
       fclose(f);
       fclose(tfp);
       exit(1);
    }
    fclose(f);
    fclose(tfp);
    sprintf(command,"cp %s %s",tn,USER_FILE);
    system(command);
    unlink(tn);
    printf("Content-type: text/html%c%c",10,10);
    printf("<HTML><HEAD><TITLE>Password Succesfully Changed</TITLE>");
    printf("<BODY><H1>Password Successfuly Changed</H1><hr size=5>");
    printf("The password for user &#160;<em>%s</em>&#160; was\n",user);
    printf("succesfully changed.<hr size=5></BODY></HTML>\n ");
    exit(0);
}
