#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <sys/signal.h>
#include <stdlib.h>
#include <time.h>

#include <sys/file.h>

#include "configure.h"


char *makeword(char *line, char stop);
char *fmakeword(FILE *f, char stop, int *len);
char x2c(char *what);
void unescape_url(char *url);
void plustospace(char *str);

char *crypt(char *pw, char *salt); /* why aren't these prototyped in include */


char *tn;

/* From local_passwd.c (C) Regents of Univ. of California blah blah */
static unsigned char itoa64[] =         /* 0 ... 63 => ascii - 64 */
        "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

to64(s, v, n)
  register char *s;
  register long v;
  register int n;
{
    while (--n >= 0) {
        *s++ = itoa64[v&0x3f];
        v >>= 6;
    }
}

void change_password(char *user, char *pw, FILE *f) {
    char *cpw, salt[3];

    (void)srand((int)time((time_t *)NULL));
    to64(&salt[0],rand(),2);
    cpw = crypt(pw,salt);
    free(pw);
    fprintf(f,"%s:%s\n",user,cpw);
}

void putline(FILE *f,char *l) {
    int x;

    for(x=0;l[x];x++) fputc(l[x],f);
    fputc('\n',f);
}

main(int argc, char *argv[]) {
    register int x;
    int cl,found;
    char *u,*t1,*t2,*p1,*p2,*user, command[256], line[256], l[256], w[256];
/*    char *info, date[60]; */
    char *info, *date;
    size_t maxsize=60;
    char  *format= "%a-%b-%y:%T";
    struct tm *tmptr;
    time_t clock;
    FILE *tfp,*f, *pfd;
    char *auth_user, *domain_name, *ip_addr;

    tn = NULL;

    printf("Content-type: text/html%c%c",10,10);

    auth_user   = getenv("REMOTE_USER");
    domain_name = getenv("REMOTE_HOST");
    ip_addr     = getenv("REMOTE_ADDR");

    if(strcmp(getenv("REQUEST_METHOD"),"POST")) {
        printf("This script should be referenced with a METHOD of POST.\n");
        printf("If you don't understand this, see this ");
        printf("<A HREF=\"http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/Docs/fill-out-forms/overview.html\">forms overview</A>.%c",10);
        exit(1);
    }
    if(strcmp(getenv("CONTENT_TYPE"),"application/x-www-form-urlencoded")) {
        printf("This script can only be used to decode form results. \n");
        exit(1);
    }
    cl = atoi(getenv("CONTENT_LENGTH"));

    user=NULL;
    p1=NULL;
    p2=NULL;
    info=NULL;
    for(x=0;cl && (!feof(stdin));x++) {
        t1 = fmakeword(stdin,'&',&cl);
        t2 = makeword(t1,'=');
        unescape_url(t1);
        unescape_url(t2);
        if(!strcmp(t2,"user")) {
            if(!user)
                user = t1;
            else {
                printf("This script was accessed from the wrong form.\n");
                exit(1);
            }
        }
        else if(!strcmp(t2,"newpasswd1")) {
            if(!p1)
                p1 = t1;
            else {
                printf("This script was accessed from the wrong form.\n");
                exit(1);
            }
        }
        else if(!strcmp(t2,"newpasswd2")) {
            if(!p2)
                p2 = t1;
            else {
                printf("This script was accessed from the wrong form.\n");
                exit(1);
            }
        }
	else if(!strcmp(t2,"information")) {
	    if(!p2)
	        info = t1;
            else {
                printf("This script was accessed from the wrong form.\n");
                exit(1);
            }
        }   

        else {
            printf("This script was accessed from the wrong form.\n");
            printf("Unrecognized directive %s.\n",t2);
            exit(1);
        }
        free(t2);
    }
    if(strcmp(p1,p2)) {
	printf("<HTML><HEAD><TITLE>Password Mismatch</TITLE></HEAD>\n");
	printf("<BODY> <H1>Password Mismatch</H1><hr size=5>");
	printf("The two copies of your the password do not match. Please");
	printf(" try again.<hr size=5>");
	exit(1);
    }

    tn = tmpnam(NULL);
    if(!(tfp = fopen(tn,"w"))) {
        fprintf(stderr,"Could not open temp file.\n");
        exit(1);
    }

    if(!(f = fopen(USER_FILE,"r"))) {
        fprintf(stderr,
                "Could not open passwd file for reading.\n",USER_FILE);
        exit(1);
    }

    found = 0;
    while(!(getline(line,256,f))) {
        if(found || (line[0] == '#') || (!line[0])) {
            putline(tfp,line);
            continue;
        }
        strcpy(l,line);
        getword(w,l,':');
        if(strcmp(user,w)) {
            putline(tfp,line);
            continue;
        }
        else {
            printf("<HTML><HEAD><TITLE>No Change: User already Exists\n");
            printf("</TITLE></HEAD><BODY>\n");
            printf("<H1 align=center>No Change: User Already Exists</H1>\n");
            printf("<hr size=5><p>The username you selected is already\n");
            printf("in use. Please press the browser's <em>back</em> button\n");
            printf("to return to the form, and try another name.<hr size=5>\n");
            printf("</body></html>\n");
            exit(0);
        }
    }
    if(!found)  {
       change_password(user,p1,tfp);
       if(!(pfd = fopen(PASSWD_LOG,"a"))) {
           fprintf(stderr,"Could not open password log file.\n");
       }
       else {
	   flock(pfd, LOCK_EX);
	   clock=time((time_t *)0);
	   date = ctime(&clock);
	   date[24]='\0';
	   fprintf(pfd,"%s  New User: %s -- Created by: %s, from host: %s, IP_address: %s\n", date, user, auth_user, domain_name, ip_addr);
	   flock(pfd,LOCK_UN);
	   fclose(pfd);
       }
    }

    fclose(f);
    fclose(tfp);
    sprintf(command,"cp %s %s",tn,USER_FILE);
    system(command);
    unlink(tn);
    printf("<HTML><HEAD><TITLE>Successful Addition</TITLE></HEAD>");
    printf("<BODY><H1>Successful Addition of New User</H1>");
    printf("The user &#160;<em>%s</em>&#160; was successfully added.",user);
    printf("You must now return to the Notices administration page to \n");
    printf("associate this user with a Department or Departmental group.\n");
    printf("</BODY></HTML>\n");
    exit(0);
}
