<!-- The first line says this is an XSL stylesheet: but note
     that it also says that XSL-related element names  must
     have the xsl: prefix. If they don't have this prefix,
     then they are assumed to be XHTML elements! -->
<xsl:stylesheet version="1.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     xmlns="http://www.w3.org/TR/xhtml1/strict">

<!-- Look for the 'doc' element: pull the content of
     the title element inside it, and paste it in inside
     the template's 'title' element. Then recursively apply
     all templates from _inside_ the main template's XHTML
     'body' element.  -->
<xsl:template match="doc">
   <html>
     <head>
        <title> <xsl:value-of select="title"/> </title>
     </head>
     <body>
     <xsl:apply-templates/>
     </body>
   </html>
  </xsl:template>

<!-- This template matches the 'title' element inside a 'doc'.
     When it finds one, it produces an 'h1' element
     that contains the content of the element it matched (i.e.,
     contains the content of the title element) It will then
     recursively apply templates to the text and markup 'included'
     inside that h1 element.  -->
  <xsl:template match="doc/title">
     <h1> <xsl:apply-templates/> </h1>
  </xsl:template>

<!-- The next two templates do exactly the same thing, except
    in these cases for 'title' element inside a 'chapter' or
    inside a 'section' element. -->
  <xsl:template match="chapter/title">
     <h2> <xsl:apply-templates/> </h2>
  </xsl:template>
  <xsl:template match="section/title">
     <h3> <xsl:apply-templates/> </h3>
  </xsl:template>

<!-- This template simply makes sure that each 'chapter'
     element is converted into an XHTML 'div' element with
     an appropriate class attribute value -->
<xsl:template match="chapter">
     <div class="chapter"> <xsl:apply-templates/> </div>
  </xsl:template>

<!-- The next template matches 'para' elements wherever they
    are, and takes the para content and pastes it inside
    an XHTML 'p' element.  It then recursively applies
    templates again. -->
  <xsl:template match="para">
     <p> <xsl:apply-templates/> </p>
  </xsl:template>

  <xsl:template match="note"></xsl:template>
  
<!-- The last template matches 'important' elements wherever they
    are, takes their content and pastes it inside
    an XHTML 'strong' element.  It then recursively applies
    templates again. -->
  <xsl:template match="important">
     <strong>  <xsl:apply-templates/> </strong>
  </xsl:template>
</xsl:stylesheet>

