#! /usr/bin/perl

use strict;
use XML::Parser::PerlSAX;
use MySAXHandler;

# XML::Parser::PerlSAX is the Perl XML parser object combined with
# the SAX interface.

# MySAXHandler is a class that defines the handlers to attach, using
# the SAX interface, to teh SAX-ified parser.

# Now, create a new 'handler' object.  Then, create a new parser
# object, and attach the 'handler' object to this parser using the
# SAX interface.

my $my_handler = MySAXHandler->new;
my $parser = XML::Parser::PerlSAX->new( Handler => $my_handler );

# Now use this to parse a file pased as a command line argument

# now, invoke the parser on a filename passed from the command
# line  -- let the thing lookp over all filenames passed to it.
# The syntax of the parse() method call is defiend by the SAX
# specifcation.

foreach my $document (@ARGV) {
  $parser->parse(Source => { SystemId => $document });
}

