package MySAXHandler;

# This package contains the event handlers that will be attached,
# using the SAX interface, to the XML parser. The SAX interface
# specification defines:
#  + the names of the functions (methods)
#  + the arguments passed to the functions (methods), and their order
#  + the return values returned by the functions.

# 1) Create new MySAXHandler object
#
sub new {
  my ($type) = @_;
  return bless {}, $type;
}

# 2) Handle Start of Document
#
sub start_document {
  my ($self) = @_;
  print "Event: Start of document\n";
}

# 3) Handle End of Document
#
sub end_document {
  my ($self) = @_;
  print "Event: End of document\n";
}

# 3) Handle Start of Element
#
sub start_element {
  my ($self, $element) = @_;
  print "Event: start element: <$element->{Name}>\n";
}

# 4) Handle End of Element
#
sub end_element {
  my ($self, $element) = @_;
  print "Event: end element: <$element->{Name}>\n";
}

# 5) Handle string of characters
#
sub characters {
  my ($self, $string ) = @_;
  my $data =   $string->{Data};
  $data =~ s/\r/\\0d/g;
  $data =~ s/\t/\\09/g;
  $data =~ s/\n/\\0a/g;
  print "Event:  text string [$data]\n";
}
1;

