/* 
 * doit-2.c 
 * Based on doit.c -- 
 *   Quick hack to play a sequence of GIF files, by Rob McCool.
 *   This code is released into the public domain. Do whatever
 *   you want with it.
 *
 * Doit-2.c Modifications by By Ian Graham, July 23 1998
 * to make it a simpler demonstration example -- or so I thought!
 */

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <dirent.h>
#include <stdio.h>

/* Define the server directives and response headers               */

#define HEADER1  "HTTP/1.0 200 OK\r\n"    /* Nph-response header   */
#define HEADER2 \
  "Content-type: multipart/x-mixed-replace;boundary=aRd4xBloobies\r\n"

/* Define the boundary strings, the Content-type header, and the   */
/* path to the directory containing the images                     */

#define BOUNDARY    "\r\n--aRd4xBloobies\r\n"
#define END_BOUND   "\r\n--aRd4xBloobies--\r\n\r\n"
#define content     "Content-type: image/gif\r\n\r\n"
#define IMG_DIR     "/abs/path/image_dir"   /*  where the files are*/

int main(int argc, char *argv[])
{
   static char   *file;
   char          *files[1024], *tmp, buf[127];
   caddr_t        fp;
   int            fd, i, ndir=0;
   DIR           *dirp;
   struct dirent *dp;
   struct stat    fi;

   /* Get list of all files in image directory -- we will          */
   /* spit them out in alphabetical order                          */
                                             /* ** GET LIST    **  */
   dirp = opendir(IMG_DIR);
   while ( ((dp = readdir(dirp)) != NULL) && (ndir < 1024) ) {
      if( strncmp(dp->d_name,".", 1)) {
         files[ndir] = malloc(strlen(dp->d_name)+1+strlen(IMG_DIR));
         sprintf(files[ndir], "%s/%s", IMG_DIR, dp->d_name);
         ndir++;
      }
   }
   closedir(dirp);
                                              /* ** GOT LIST   **  */
   /* Write out server directives, and first multipart boundary    */
                           
                        /* ** PRINT SERVER RESPONSE HEADERS    **  */
   if(write(STDOUT_FILENO, HEADER1, strlen(HEADER1)) == -1)   exit(0);
   if(write(STDOUT_FILENO, HEADER2, strlen(HEADER2)) == -1)   exit(0);
   if(write(STDOUT_FILENO, BOUNDARY, strlen(BOUNDARY)) == -1) exit(0);
   
   /* Now loop over all files, and write to client                 */
   for (i=0; i<ndir; i++)  {
      fprintf(stderr, "Doing output loop -- i=%i\n", i);
      sleep(1);                     
                                 /* ** WRITE PART content-type   ***/
      if(write(STDOUT_FILENO, content, strlen(content)) == -1) exit(0);
      if( ( fd=open(files[i],O_RDONLY)) == -1 ) {
          fprintf(stderr,"Unable to open file %s\n", files[i]);
          continue;
      }
      fstat(fd, &fi);                  /*  find size of file and   */
      tmp=malloc(fi.st_size*sizeof(char)); /*allocate memory for it*/
      read(fd, tmp, fi.st_size);         
                                     /* ** WRITE THE IMAGE DATA ** */
      if(write(STDOUT_FILENO, tmp, fi.st_size) == -1) exit(0);     
                                /* ERROR: unable to write image    */
      free(tmp);
      close(fd);
                                  /* ** WRITE THE PART BOUNDARY ** */
      if(write(STDOUT_FILENO, BOUNDARY, strlen(BOUNDARY)) == -1) exit(0);
                                /* ERROR unable to write boundary  */
   }
   
   /* Write out the boundary marking the end of the multipart      */
   /* message. Then we are done.                                   */

   write(STDOUT_FILENO, END_BOUND, strlen(END_BOUND));
   exit(0);
}

