/* 
 * doit-2.c 
 * Based on doit.c -- 
 *   Quick hack to play a sequence of GIF files.
 *   Rob McCool
 *   This code is released into the public domain. Do whatever
 *   you want with it.
 *
 * Doit-2.c Modifications by By Ian Graham, July 23 1995
 * to make it a simpler demonstration example -- or so I thought!
*/

#include <sys/types.h>
#include <sys/mman.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <dirent.h>
#include <stdio.h>

/* Define the server directives and response headers                 */

#define HEADER1  "Status: HTTP/1.0 200\r\n"
#define HEADER2 \
  "Content-type: multipart/x-mixed-replace;boundary=aRd4xBloobies\r\n"

/* Define the boundary strings, the Content-type header, and the     */
/* path to the directory containing the images                       */

#define BOUNDARY    "\r\n--aRd4xBloobies\r\n"
#define END_BOUND   "\r\n--aRd4xBloobies--\r\n\r\n"
#define CONTENT     "Content-type: image/gif\r\n\r\n"
#define IMG_DIR     "/svc/www/ImageTest"


int main(int argc, char *argv[])
{
   static char *file;
   char          *files[1024];
   caddr_t        fp;
   int            fd, i, ndir=0;
   DIR           *dirp;
   struct dirent *dp;
   struct stat    fi;

   /* Get list of all files in image directory -- we will         */
   /* spit them out in alphabetical order                         */

   dirp = opendir(IMG_DIR);
   while ( ((dp = readdir(dirp)) != NULL) && (ndir < 1024) ) {
      if( strncmp(dp->d_name,".", 1)) {
         files[ndir] = malloc(strlen(dp->d_name)+1+strlen(IMG_DIR));
         sprintf(files[ndir], "%s/%s", IMG_DIR, dp->d_name);
         ndir++;
      }
   }
   closedir(dirp);
   
   /* Write out server directives, and first multipart boundary    */
  
   if(write(STDOUT_FILENO, HEADER1, strlen(HEADER1)) == -1)   exit(0);
   if(write(STDOUT_FILENO, HEADER2, strlen(HEADER2)) == -1)   exit(0);
   if(write(STDOUT_FILENO, BOUNDARY, strlen(BOUNDARY)) == -1) exit(0);
   
   /* Now loop over all files, and write to client                 */
   for (i=0; i<ndir; i++)  {
      fprintf(stderr, "Doing output loop -- i=%i\n", i);
/*      sleep(1); */
      if(write(STDOUT_FILENO, CONTENT, strlen(CONTENT)) == -1) exit(0);
      if( ( fd=open(files[i],O_RDONLY)) == -1 ) continue;
      fstat(fd, &fi); 
      fp=mmap(NULL, fi.st_size, PROT_READ, MAP_PRIVATE, fd, 0);
      if(fp == (caddr_t) -1 ) 
         exit(0);           /* ERROR: unable to map memory */
      if(write(STDOUT_FILENO, (void *)fp, fi.st_size) == -1)
         exit(0);           /* ERROR: unable to write image */
      munmap(fp, fi.st_size);
      close(fd);
      if(write(STDOUT_FILENO, BOUNDARY, strlen(BOUNDARY)) == -1) 
        exit(0);            /* ERROR unable to write boundary */
   }
   
   /* Write out the boundary marking the end of the multipart       */
   /* message. Then we are done.                                    */

   write(STDOUT_FILENO, END_BOUND, strlen(END_BOUND));
   exit(0);
}

